"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.configSchema = exports.config = exports.CRAWLERS_INDEX = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async initializerContext => {
  const {
    EnterpriseSearchPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new EnterpriseSearchPlugin(initializerContext);
};
exports.plugin = plugin;
const configSchema = exports.configSchema = _configSchema.schema.object({
  accessCheckTimeout: _configSchema.schema.number({
    defaultValue: 5000
  }),
  accessCheckTimeoutWarning: _configSchema.schema.number({
    defaultValue: 300
  }),
  appsDisabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  customHeaders: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDefaultIngestPipeline: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDocumentLevelSecurityEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasIncrementalSyncEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasNativeConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasWebCrawler: _configSchema.schema.boolean({
    defaultValue: true
  }),
  host: _configSchema.schema.maybe(_configSchema.schema.string()),
  isCloud: _configSchema.schema.boolean({
    defaultValue: false
  }),
  ssl: _configSchema.schema.object({
    certificateAuthorities: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1
    }), _configSchema.schema.string()])),
    verificationMode: _configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('certificate'), _configSchema.schema.literal('full')], {
      defaultValue: 'full'
    })
  }),
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
});
const config = exports.config = {
  deprecations: ({
    deprecate,
    unused
  }) => [unused('canDeployEntSearch', {
    level: 'warning'
  }), (deprecationConfig, fromPath, addDeprecation, context) => {
    [deprecate('ssl', '9.0.0', {
      documentationUrl: context.docLinks.enterpriseSearch.upgrade9x,
      level: 'critical',
      title: ENT_SEARCH_NODE_DEPRECATION_TITLE
    }), deprecate('accessCheckTimeout', '9.0.0', {
      documentationUrl: context.docLinks.enterpriseSearch.upgrade9x,
      level: 'critical',
      title: ENT_SEARCH_NODE_DEPRECATION_TITLE
    }), deprecate('accessCheckTimeoutWarning', '9.0.0', {
      documentationUrl: context.docLinks.enterpriseSearch.upgrade9x,
      level: 'critical',
      title: ENT_SEARCH_NODE_DEPRECATION_TITLE
    }), deprecate('isCloud', '9.0.0', {
      level: 'critical'
    }), deprecate('ui', '9.0.0', {
      level: 'critical'
    })].forEach(deprecation => deprecation(deprecationConfig, fromPath, addDeprecation, context));
  }],
  exposeToBrowser: {
    host: true,
    ui: true
  },
  schema: configSchema
};
const CRAWLERS_INDEX = exports.CRAWLERS_INDEX = '.ent-search-actastic-crawler2_configurations_v2';
const ENT_SEARCH_NODE_DEPRECATION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.deprecations.config.nodeValuesTitle', {
  defaultMessage: 'Enterprise Search configuration values must be removed'
});