"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _deprecation_callout = require("../../../shared/deprecation_callout/deprecation_callout");
var _doc_links = require("../../../shared/doc_links");
var _app_logic = require("../../app_logic");
var _layout = require("../../components/layout");
var _gated_form_page = require("./gated_form_page");
var _onboarding_steps = require("./onboarding_steps");
var _organization_stats = require("./organization_stats");
var _overview_logic = require("./overview_logic");
var _recent_activity = require("./recent_activity");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONBOARDING_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingHeader.title', {
  defaultMessage: 'Get started with Workplace Search'
});
const HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewHeader.title', {
  defaultMessage: 'Organization overview'
});
const ONBOARDING_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingHeader.description', {
  defaultMessage: 'Complete the following to set up your organization.'
});
const HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewHeader.description', {
  defaultMessage: "Your organizations's statistics and activity"
});
const Overview = () => {
  const {
    organization: {
      name: orgName,
      defaultOrgName,
      kibanaUIsEnabled
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    initializeOverview
  } = (0, _kea.useActions)(_overview_logic.OverviewLogic);
  const {
    dataLoading,
    hasUsers,
    hasOrgSources,
    isOldAccount
  } = (0, _kea.useValues)(_overview_logic.OverviewLogic);
  (0, _react.useEffect)(() => {
    initializeOverview();
  }, [initializeOverview]);
  const hideOnboarding = hasUsers && hasOrgSources && isOldAccount && orgName !== defaultOrgName;
  const headerTitle = hideOnboarding ? HEADER_TITLE : ONBOARDING_HEADER_TITLE;
  const headerDescription = hideOnboarding ? HEADER_DESCRIPTION : ONBOARDING_HEADER_DESCRIPTION;
  const [showDeprecationCallout, setShowDeprecationCallout] = _react.default.useState(!sessionStorage.getItem('workplaceSearchHideDeprecationCallout'));
  const onDismissDeprecationCallout = () => {
    setShowDeprecationCallout(false);
    sessionStorage.setItem('workplaceSearchHideDeprecationCallout', 'true');
  };
  return kibanaUIsEnabled ? /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [],
    pageHeader: dataLoading ? undefined : {
      pageTitle: headerTitle,
      description: headerDescription
    },
    pageViewTelemetry: "overview",
    isLoading: dataLoading
  }, showDeprecationCallout ? /*#__PURE__*/_react.default.createElement(_deprecation_callout.EnterpriseSearchDeprecationCallout, {
    onDismissAction: onDismissDeprecationCallout,
    learnMoreLinkUrl: _doc_links.docLinks.workplaceSearchGuide
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), !hideOnboarding && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_onboarding_steps.OnboardingSteps, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_organization_stats.OrganizationStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_recent_activity.RecentActivity, null)) : /*#__PURE__*/_react.default.createElement(_gated_form_page.WorkplaceSearchGatePage, {
    isLoading: dataLoading
  });
};
exports.Overview = Overview;