"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrganizationStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _content_section = require("../../components/shared/content_section");
var _routes = require("../../routes");
var _overview_logic = require("./overview_logic");
var _statistic_card = require("./statistic_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OrganizationStats = () => {
  const {
    sourcesCount,
    pendingInvitationsCount,
    accountsCount,
    privateSourcesCount
  } = (0, _kea.useValues)(_overview_logic.OverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.organizationStats.title",
      defaultMessage: "Usage statistics"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_statistic_card.StatisticCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.organizationStats.organizationalSources', {
      defaultMessage: 'Organizational sources'
    }),
    count: sourcesCount,
    actionPath: _routes.SOURCES_PATH
  }), /*#__PURE__*/_react.default.createElement(_statistic_card.StatisticCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.organizationStats.invitations', {
      defaultMessage: 'Invitations'
    }),
    count: pendingInvitationsCount,
    actionPath: _routes.USERS_AND_ROLES_PATH
  }), /*#__PURE__*/_react.default.createElement(_statistic_card.StatisticCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.organizationStats.activeUsers', {
      defaultMessage: 'Active users'
    }),
    count: accountsCount,
    actionPath: _routes.USERS_AND_ROLES_PATH
  }), /*#__PURE__*/_react.default.createElement(_statistic_card.StatisticCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.organizationStats.privateSources', {
      defaultMessage: 'Private sources'
    }),
    count: privateSourcesCount
  })));
};
exports.OrganizationStats = OrganizationStats;