"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesView = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _loading = require("../../../shared/loading");
var _source_icon = require("../../components/shared/source_icon");
var _constants = require("./constants");
var _sources_logic = require("./sources_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesView = ({
  children
}) => {
  const {
    resetPermissionsModal
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  const {
    dataLoading,
    permissionsModal
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  if (dataLoading) return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  const PermissionsModal = ({
    addedSourceName,
    serviceType
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: resetPermissionsModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
    serviceType: serviceType,
    name: addedSourceName,
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourcesView.modal.heading', {
    defaultMessage: '{addedSourceName} requires additional configuration',
    values: {
      addedSourceName
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sourcesView.modal.success",
    defaultMessage: "{addedSourceName} has been successfully connected and initial content synchronization is already underway. Since you have elected to synchronize document-level permission information, you must now provide user and group mappings using the {externalIdentitiesLink}.",
    values: {
      addedSourceName,
      externalIdentitiesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchExternalIdentities
      }, _constants.EXTERNAL_IDENTITIES_LINK)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sourcesView.modal.docPermissions.description",
    defaultMessage: "Documents will not be searchable from Workplace Search until user and group mappings have been configured. {documentPermissionsLink}.",
    values: {
      documentPermissionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchDocumentPermissions
      }, _constants.DOCUMENT_PERMISSIONS_LINK)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: resetPermissionsModal,
    fill: true
  }, _constants.UNDERSTAND_BUTTON)));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (permissionsModal === null || permissionsModal === void 0 ? void 0 : permissionsModal.additionalConfiguration) && /*#__PURE__*/_react.default.createElement(PermissionsModal, {
    addedSourceName: permissionsModal.addedSourceName,
    serviceType: permissionsModal.serviceType
  }), children);
};
exports.SourcesView = SourcesView;