"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailableSourcesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _licensing = require("../../../../../shared/licensing");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _source_icon = require("../../../../components/shared/source_icon");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _byo_source_prompt = require("./byo_source_prompt");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AvailableSourcesList = ({
  sources
}) => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const getSourceCard = ({
    accountContextOnly,
    baseServiceType,
    name,
    serviceType
  }) => {
    const addPath = (0, _routes.getAddPath)(serviceType, baseServiceType);
    const disabled = !hasPlatinumLicense && accountContextOnly;
    const connectButton = () => {
      if (disabled) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          content: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.availableSourceList.toolTipContent', {
            defaultMessage: '{name} is configurable as a Private Source, available with a Platinum subscription.',
            values: {
              name
            }
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          disabled: true
        }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.availableSourceList.connectButtonLabel', {
          defaultMessage: 'Connect'
        })));
      } else {
        return /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
          to: (0, _routes.getSourcesPath)(addPath, true) + (serviceType === 'custom' || serviceType === 'external' ? '' : '/intro')
        }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.availableSourceList.connectButtonLabel', {
          defaultMessage: 'Connect'
        }));
      }
    };
    const card = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
      serviceType: baseServiceType || serviceType,
      name: name,
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, connectButton())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "none"
    }));
    return card;
  };
  const visibleSources = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    direction: "column",
    gutterSize: "l"
  }, sources.map((source, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: i,
    "data-test-subj": "AvailableSourceListItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "stretch",
    "data-test-subj": "AvailableSourceCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getSourceCard(source))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "AvailableSourceListItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "stretch",
    "data-test-subj": "AvailableSourceCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getSourceCard(_source_data.staticCustomSourceData))))));
  const emptyState = /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "AvailableSourceEmptyState"
  }, _constants.AVAILABLE_SOURCE_EMPTY_STATE);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _constants.AVAILABLE_SOURCE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _constants.AVAILABLE_SOURCE_BODY, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _routes.getSourcesPath)(_routes.ADD_CUSTOM_PATH, true),
    "data-test-subj": "CustomAPISourceLink"
  }, _constants.AVAILABLE_SOURCE_CUSTOM_SOURCE_BUTTON), ".")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), sources.length > 0 ? visibleSources : emptyState, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_byo_source_prompt.BYOSourcePrompt, null));
};
exports.AvailableSourcesList = AvailableSourcesList;