"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../../../app_logic");
var _share_circle = _interopRequireDefault(require("../../../../assets/share_circle.svg"));
var _layout = require("../../../../components/layout");
var _content_section = require("../../../../components/shared/content_section");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants = require("../../../../constants");
var _sources_logic = require("../../sources_logic");
var _available_sources_list = require("./available_sources_list");
var _configured_sources_list = require("./configured_sources_list");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceList = () => {
  const {
    contentSources,
    dataLoading,
    availableSources,
    configuredSources
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  const {
    initializeSources,
    resetSourcesState
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const [filterValue, setFilterValue] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    initializeSources();
    return resetSourcesState;
  }, []);
  const hasSources = contentSources.length > 0;
  const showConfiguredSourcesList = configuredSources.find(({
    serviceType
  }) => serviceType !== _constants.CUSTOM_SERVICE_TYPE);
  const BASE_DESCRIPTION = hasSources ? '' : _constants2.ADD_SOURCE_NEW_SOURCE_DESCRIPTION;
  const PAGE_CONTEXT_DESCRIPTION = isOrganization ? _constants2.ADD_SOURCE_ORG_SOURCE_DESCRIPTION : _constants2.ADD_SOURCE_PRIVATE_SOURCE_DESCRIPTION;
  const PAGE_DESCRIPTION = BASE_DESCRIPTION + PAGE_CONTEXT_DESCRIPTION;
  const HAS_SOURCES_TITLE = isOrganization ? _constants2.ADD_SOURCE_ORG_SOURCES_TITLE : _constants2.ADD_SOURCE_PRIVATE_SOURCES_TITLE;
  const PAGE_TITLE = hasSources ? HAS_SOURCES_TITLE : _constants2.ADD_SOURCE_NO_SOURCES_TITLE;
  const handleFilterChange = e => setFilterValue(e.target.value);
  const filterSources = (source, sources) => {
    if (!filterValue) return true;
    const filterSource = sources.find(({
      serviceType
    }) => serviceType === source.serviceType);
    const filteredName = (filterSource === null || filterSource === void 0 ? void 0 : filterSource.name) || '';
    return filteredName.toLowerCase().indexOf(filterValue.toLowerCase()) > -1;
  };
  const filterAvailableSources = source => filterSources(source, availableSources);
  const filterConfiguredSources = source => filterSources(source, configuredSources);
  const visibleAvailableSources = availableSources.filter(filterAvailableSources);
  const visibleConfiguredSources = configuredSources.filter(filterConfiguredSources);
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE],
    pageViewTelemetry: "add_source",
    pageHeader: dataLoading ? undefined : {
      pageTitle: PAGE_TITLE,
      description: PAGE_DESCRIPTION
    },
    isLoading: dataLoading
  }, !isOrganization && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: PAGE_TITLE,
    description: PAGE_DESCRIPTION
  })), showConfiguredSourcesList || isOrganization ? /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "FilterSourcesInput",
    value: filterValue,
    onChange: handleFilterChange,
    fullWidth: true,
    placeholder: _constants2.ADD_SOURCE_PLACEHOLDER
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), showConfiguredSourcesList && /*#__PURE__*/_react.default.createElement(_configured_sources_list.ConfiguredSourcesList, {
    isOrganization: isOrganization,
    sources: visibleConfiguredSources
  }), isOrganization && /*#__PURE__*/_react.default.createElement(_available_sources_list.AvailableSourcesList, {
    sources: visibleAvailableSources
  })) : /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _share_circle.default,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.ADD_SOURCE_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _constants2.ADD_SOURCE_EMPTY_BODY)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })))));
};
exports.AddSourceList = AddSourceList;