"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusItem = ({
  details
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const formattedDetails = details.join('\n');
  const popoverTrigger = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onButtonClick,
    color: "text",
    iconType: "questionInCircle",
    "aria-label": _constants.STATUS_POPOVER_TOOLTIP
  });
  const infoPopover = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverTrigger,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    fontSize: "m",
    paddingSize: "m",
    style: {
      maxWidth: 300
    },
    isCopyable: true
  }, formattedDetails), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: formattedDetails
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "copy",
    onClick: copy
  }, _constants.COPY_TEXT)));
  return infoPopover;
};
exports.StatusItem = StatusItem;