"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _constants2 = require("../../../constants");
var _constants3 = require("../../../views/content_sources/constants");
var _source_row = require("../source_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesTable = ({
  sources,
  showDetails,
  isOrganization,
  onSearchableToggle
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    responsiveBreakpoint: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants2.SOURCE), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants3.STATUS_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants2.DOCUMENTS_HEADER), onSearchableToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants2.SEARCHABLE_HEADER), isOrganization && /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right"
  }, _constants.ACTIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, sources.map(source => /*#__PURE__*/_react.default.createElement(_source_row.SourceRow, {
    key: source.id,
    source: source,
    showDetails: showDetails,
    isOrganization: isOrganization,
    onSearchableToggle: onSearchableToggle
  }))));
};
exports.SourcesTable = SourcesTable;