"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateSourcesSidebar = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../../app_logic");
var _constants = require("../../../constants");
var _source_sub_nav = require("../../../views/content_sources/components/source_sub_nav");
var _source_logic = require("../../../views/content_sources/source_logic");
var _view_content_header = require("../../shared/view_content_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateSourcesSidebar = () => {
  const {
    account: {
      canCreatePrivateSources
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const PAGE_TITLE = canCreatePrivateSources ? _constants.PRIVATE_CAN_CREATE_PAGE_TITLE : _constants.PRIVATE_VIEW_ONLY_PAGE_TITLE;
  const PAGE_DESCRIPTION = canCreatePrivateSources ? _constants.PRIVATE_CAN_CREATE_PAGE_DESCRIPTION : _constants.PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION;
  const {
    contentSource: {
      id = ''
    }
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const navItems = [{
    id,
    name: '',
    items: (0, _source_sub_nav.useSourceSubNav)()
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    headingLevel: 1,
    title: PAGE_TITLE,
    description: PAGE_DESCRIPTION
  }), id && /*#__PURE__*/_react.default.createElement(_eui.EuiSideNav, {
    items: navItems,
    mobileBreakpoints: []
  }));
};
exports.PrivateSourcesSidebar = PrivateSourcesSidebar;