"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersAndRolesRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsersAndRolesRowActions = ({
  onManageClick,
  onDeleteClick,
  username
}) => {
  const [deleteModalVisible, setVisible] = (0, _react.useState)(false);
  const showDeleteModal = () => setVisible(true);
  const closeDeleteModal = () => setVisible(false);
  const title = username ? (0, _constants2.USER_MODAL_TITLE)(username) : _constants2.REMOVE_ROLE_MAPPING_TITLE;
  const text = username ? _constants2.USER_MODAL_TEXT : _constants2.ROLE_MODAL_TEXT;
  const confirmButton = username ? _constants2.REMOVE_USER_BUTTON : _constants2.REMOVE_ROLE_MAPPING_BUTTON;
  const deleteModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: closeDeleteModal,
    onConfirm: () => {
      onDeleteClick();
      closeDeleteModal();
    },
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: confirmButton,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, text));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteModalVisible && deleteModal, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onManageClick,
    iconType: "pencil",
    "aria-label": _constants.MANAGE_BUTTON_LABEL
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: showDeleteModal,
    iconType: "trash",
    "aria-label": _constants.DELETE_BUTTON_LABEL
  }));
};
exports.UsersAndRolesRowActions = UsersAndRolesRowActions;