"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappingsHeading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMappingsHeading = ({
  productName,
  docsLink,
  onClick
}) => /*#__PURE__*/_react.default.createElement("header", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _constants.ROLE_MAPPINGS_HEADING_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement("p", null, (0, _constants.ROLE_MAPPINGS_HEADING_DESCRIPTION)(productName), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  external: true,
  href: docsLink,
  target: "_blank"
}, _constants.ROLE_MAPPINGS_HEADING_DOCS_LINK)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fill: true,
  onClick: onClick
}, _constants.ROLE_MAPPINGS_HEADING_BUTTON))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
exports.RoleMappingsHeading = RoleMappingsHeading;