"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexHealthToHealthColor = exports.healthColorsMapSelectable = exports.healthColorsMap = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const healthColorsMap = exports.healthColorsMap = {
  red: 'danger',
  green: 'success',
  yellow: 'warning',
  unavailable: ''
};
const healthColorsMapSelectable = exports.healthColorsMapSelectable = {
  red: 'danger',
  RED: 'danger',
  green: 'success',
  GREEN: 'success',
  yellow: 'warning',
  YELLOW: 'warning',
  unknown: '',
  unavailable: ''
};
const indexHealthToHealthColor = health => {
  var _healthColorsMap;
  if (!health) return '';
  return (_healthColorsMap = healthColorsMap[health.toLowerCase()]) !== null && _healthColorsMap !== void 0 ? _healthColorsMap : '';
};
exports.indexHealthToHealthColor = indexHealthToHealthColor;