"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BehavioralAnalyticsProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _behavioral_analytics_logo = _interopRequireDefault(require("../../assets/behavioral_analytics_logo.svg"));
var _product_card = require("../product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BehavioralAnalyticsProductCard = ({
  hasBorder = true,
  hasShadow = true
}) => /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
  hasBorder: hasBorder,
  hasShadow: hasShadow,
  cta: _i18n.i18n.translate('xpack.enterpriseSearch.behavioralAnalytics.productCardCTA', {
    defaultMessage: 'Explore Behavioral Analytics'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.behavioralAnalytics.description', {
    defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications'
  }),
  emptyCta: true,
  icon: _behavioral_analytics_logo.default,
  iconSize: "l",
  name: _constants.ANALYTICS_PLUGIN.NAME,
  productId: _constants.ANALYTICS_PLUGIN.ID,
  url: _constants.ANALYTICS_PLUGIN.URL
});
exports.BehavioralAnalyticsProductCard = BehavioralAnalyticsProductCard;