"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApiKey = exports.CreateApiKeyAPILogic = void 0;
var _create_api_logic = require("../../shared/api_logic/create_api_logic");
var _http = require("../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createApiKey = async args => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = '/internal/enterprise_search/api_keys';
  const response = await http.post(route, {
    body: JSON.stringify(args)
  });
  return response;
};
exports.createApiKey = createApiKey;
const CreateApiKeyAPILogic = exports.CreateApiKeyAPILogic = (0, _create_api_logic.createApiLogic)(['overview', 'create_api_key_api_logic'], createApiKey);