"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDomainValidation = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_domain_logic = require("./add_domain_logic");
var _validation_step_panel = require("./validation_step_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDomainValidation = () => {
  const {
    addDomainFormInputValue,
    canIgnoreValidationFailure,
    domainValidationResult,
    ignoreValidationFailure
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  const {
    setIgnoreValidationFailure
  } = (0, _kea.useActions)(_add_domain_logic.AddDomainLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validation_step_panel.ValidationStepPanel, {
    step: domainValidationResult.steps.initialValidation,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.initialVaidationLabel', {
      defaultMessage: 'Initial validation'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validation_step_panel.ValidationStepPanel, {
    step: domainValidationResult.steps.networkConnectivity,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.networkConnectivityLabel', {
      defaultMessage: 'Network connectivity'
    }),
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      href: addDomainFormInputValue,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.testUrlButtonLabel', {
      defaultMessage: 'Test URL in the browser'
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validation_step_panel.ValidationStepPanel, {
    step: domainValidationResult.steps.indexingRestrictions,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.indexingRestrictionsLabel', {
      defaultMessage: 'Indexing restrictions'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validation_step_panel.ValidationStepPanel, {
    step: domainValidationResult.steps.contentVerification,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.contentVerificationLabel', {
      defaultMessage: 'Content verification'
    })
  })), canIgnoreValidationFailure && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `crawler_domain_${addDomainFormInputValue}`,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.ignoreValidationTitle', {
      defaultMessage: 'Ignore validation failures and continue'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.ignoreValidationDescription', {
      defaultMessage: 'The web crawler will be unable to index any content on this domain until the errors above are addressed.'
    }))),
    checked: ignoreValidationFailure,
    onChange: e => setIgnoreValidationFailure(e.target.checked)
  })))));
};
exports.AddDomainValidation = AddDomainValidation;