"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiCrawlScheduler = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cron_editor = require("@kbn/search-connectors/components/cron_editor");
var _doc_links = require("../../../../../shared/doc_links/doc_links");
var _indices = require("../../../../utils/indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiCrawlScheduler = ({
  index,
  interval,
  schedulingEnabled,
  setConnectorSchedulingInterval,
  onSetConnectorSchedulingEnabled
}) => {
  if (!(0, _indices.isCrawlerIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.multiCrawlSchedulingFrequency', {
    defaultMessage: 'Crawl frequency'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: schedulingEnabled,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.multiCrawlSchedulingEnabled', {
      defaultMessage: 'Enable recurring crawls with the following schedule'
    }),
    onChange: e => onSetConnectorSchedulingEnabled(e.target.checked),
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.cronSchedulingTitle', {
    defaultMessage: 'Specific time scheduling'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.cronSchedulingDescription', {
    defaultMessage: 'Define the frequency and time for scheduled crawls. The crawler uses UTC as its timezone.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_cron_editor.EnterpriseSearchCronEditor, {
    disabled: !schedulingEnabled,
    scheduling: {
      interval,
      enabled: schedulingEnabled
    },
    onChange: setConnectorSchedulingInterval
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.scheduleDescription', {
    defaultMessage: 'The crawl schedule will perform a full crawl on every domain on this index.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.crawlerManaging,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.readMoreLink', {
    defaultMessage: 'Learn more about scheduling'
  }))))));
};
exports.MultiCrawlScheduler = MultiCrawlScheduler;