"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewIndexCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _ingestion_card = require("../shared/ingestion_card/ingestion_card");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METHOD_CARD_OPTIONS = {
  [_constants.INGESTION_METHOD_IDS.CRAWLER]: {
    buttonIcon: (0, _utils.getIngestionMethodButtonIcon)(_constants.INGESTION_METHOD_IDS.CRAWLER),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.description', {
      defaultMessage: 'Discover, extract, and index searchable content from websites and knowledge bases'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.label', {
        defaultMessage: 'Crawl URL'
      }),
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.nocodeLabel', {
        defaultMessage: 'No code'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.CRAWLER),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.title', {
      defaultMessage: 'Web crawler'
    })
  },
  [_constants.INGESTION_METHOD_IDS.CONNECTOR]: {
    buttonIcon: (0, _utils.getIngestionMethodButtonIcon)(_constants.INGESTION_METHOD_IDS.CONNECTOR),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.description', {
      defaultMessage: 'Extract, transform, index and sync data from a third-party data source'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.label', {
        defaultMessage: 'Choose a source connector'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.CONNECTOR),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.title', {
      defaultMessage: 'Connectors'
    })
  },
  [_constants.INGESTION_METHOD_IDS.API]: {
    buttonIcon: (0, _utils.getIngestionMethodButtonIcon)(_constants.INGESTION_METHOD_IDS.API),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.description', {
      defaultMessage: 'Use the API to connect directly to your Elasticsearch index endpoint.'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.label', {
        defaultMessage: 'Create API Index'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.API),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.title', {
      defaultMessage: 'API'
    })
  }
};
const NewIndexCard = ({
  disabled,
  onSelect,
  type
}) => {
  if (!METHOD_CARD_OPTIONS[type]) {
    return null;
  }
  const {
    buttonIcon,
    icon,
    title,
    description,
    footer
  } = METHOD_CARD_OPTIONS[type];
  return /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    isDisabled: disabled,
    "data-test-subj": "entSearch-content-newIndexCard-cardBody",
    logo: icon,
    buttonIcon: buttonIcon,
    buttonLabel: footer.buttonLabel,
    title: title,
    description: description,
    onClick: onSelect
  });
};
exports.NewIndexCard = NewIndexCard;