"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRetentionConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _log_retention = require("../../log_retention");
var _generic_confirmation_modal = require("./generic_confirmation_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRetentionConfirmationModal = () => {
  var _logRetention$LogRete, _logRetention$LogRete2, _logRetention$LogRete3, _logRetention$LogRete4, _logRetention$LogRete5, _logRetention$LogRete6, _logRetention$LogRete7, _logRetention$LogRete8;
  const CANNOT_BE_RECOVERED_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.recovery', {
    defaultMessage: 'You cannot recover deleted data.'
  });
  const DISABLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.disable', {
    defaultMessage: 'DISABLE'
  });
  const {
    closeModals,
    saveLogRetention
  } = (0, _kea.useActions)(_log_retention.LogRetentionLogic);
  const {
    logRetention,
    openedModal
  } = (0, _kea.useValues)(_log_retention.LogRetentionLogic);
  if (openedModal === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, openedModal === _log_retention.LogRetentionOptions.Analytics && /*#__PURE__*/_react.default.createElement(_generic_confirmation_modal.GenericConfirmationModal, {
    "data-test-subj": "AnalyticsLogRetentionConfirmationModal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.analytics.title', {
      defaultMessage: 'Disable Analytics writes'
    }),
    subheading: logRetention && ((_logRetention$LogRete = logRetention[_log_retention.LogRetentionOptions.Analytics].retentionPolicy) === null || _logRetention$LogRete === void 0 ? void 0 : _logRetention$LogRete.minAgeDays) && _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.analytics.subheading', {
      defaultMessage: 'Your Analytics Logs are currently being stored for {minAgeDays} days.',
      values: {
        minAgeDays: (_logRetention$LogRete2 = logRetention[_log_retention.LogRetentionOptions.Analytics].retentionPolicy) === null || _logRetention$LogRete2 === void 0 ? void 0 : _logRetention$LogRete2.minAgeDays
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.analytics.description', {
      defaultMessage: 'When you disable writing, engines stop logging analytics events. Your existing data is deleted according to the storage time frame.'
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, CANNOT_BE_RECOVERED_TEXT)))),
    target: DISABLE_TEXT,
    onClose: closeModals,
    onSave: () => saveLogRetention(_log_retention.LogRetentionOptions.Analytics, false)
  }), openedModal === _log_retention.LogRetentionOptions.API && /*#__PURE__*/_react.default.createElement(_generic_confirmation_modal.GenericConfirmationModal, {
    "data-test-subj": "APILogRetentionConfirmationModal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.api.title', {
      defaultMessage: 'Disable API writes'
    }),
    subheading: logRetention && (logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete3 = logRetention[_log_retention.LogRetentionOptions.API].retentionPolicy) === null || _logRetention$LogRete3 === void 0 ? void 0 : _logRetention$LogRete3.minAgeDays) && _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.api.subheading', {
      defaultMessage: 'Your API Logs are currently being stored for {minAgeDays} days.',
      values: {
        minAgeDays: logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete4 = logRetention[_log_retention.LogRetentionOptions.API].retentionPolicy) === null || _logRetention$LogRete4 === void 0 ? void 0 : _logRetention$LogRete4.minAgeDays
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.api.description', {
      defaultMessage: 'When you disable writing, engines stop logging API events. Your existing data is deleted according to the storage time frame.'
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, CANNOT_BE_RECOVERED_TEXT)))),
    target: DISABLE_TEXT,
    onClose: closeModals,
    onSave: () => saveLogRetention(_log_retention.LogRetentionOptions.API, false)
  }), openedModal === _log_retention.LogRetentionOptions.Audit && /*#__PURE__*/_react.default.createElement(_generic_confirmation_modal.GenericConfirmationModal, {
    "data-test-subj": "APILogRetentionConfirmationModal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.audit.title', {
      defaultMessage: 'Disable Audit writes'
    }),
    subheading: logRetention && (logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete5 = logRetention[_log_retention.LogRetentionOptions.Audit].retentionPolicy) === null || _logRetention$LogRete5 === void 0 ? void 0 : _logRetention$LogRete5.minAgeDays) && _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.audit.subheading', {
      defaultMessage: 'Your audit Logs are currently being stored for {minAgeDays} days.',
      values: {
        minAgeDays: logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete6 = logRetention[_log_retention.LogRetentionOptions.Audit].retentionPolicy) === null || _logRetention$LogRete6 === void 0 ? void 0 : _logRetention$LogRete6.minAgeDays
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.audit.description', {
      defaultMessage: 'When you disable writing, engines stop logging audit events. Your existing data is deleted according to the storage time frame.'
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, CANNOT_BE_RECOVERED_TEXT)))),
    target: DISABLE_TEXT,
    onClose: closeModals,
    onSave: () => saveLogRetention(_log_retention.LogRetentionOptions.Audit, false)
  }), openedModal === _log_retention.LogRetentionOptions.Crawler && /*#__PURE__*/_react.default.createElement(_generic_confirmation_modal.GenericConfirmationModal, {
    "data-test-subj": "CrawlerLogRetentionConfirmationModal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.crawler.title', {
      defaultMessage: 'Disable Web Crawler writes'
    }),
    subheading: logRetention && (logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete7 = logRetention[_log_retention.LogRetentionOptions.Crawler].retentionPolicy) === null || _logRetention$LogRete7 === void 0 ? void 0 : _logRetention$LogRete7.minAgeDays) && _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.crawler.subheading', {
      defaultMessage: 'Your Web Crawler Logs are currently being stored for {minAgeDays} days.',
      values: {
        minAgeDays: logRetention === null || logRetention === void 0 ? void 0 : (_logRetention$LogRete8 = logRetention[_log_retention.LogRetentionOptions.Crawler].retentionPolicy) === null || _logRetention$LogRete8 === void 0 ? void 0 : _logRetention$LogRete8.minAgeDays
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.crawler.description', {
      defaultMessage: 'When you disable writing, engines stop logging Web Crawler events. Your existing data is deleted according to the storage time frame.'
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, CANNOT_BE_RECOVERED_TEXT)))),
    target: DISABLE_TEXT,
    onClose: closeModals,
    onSave: () => saveLogRetention(_log_retention.LogRetentionOptions.Crawler, false)
  }));
};
exports.LogRetentionConfirmationModal = LogRetentionConfirmationModal;