"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericConfirmationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenericConfirmationModal = ({
  description,
  onClose,
  onSave,
  subheading,
  target,
  title
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)('');
  const onConfirm = () => {
    setInputValue('');
    onSave();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    initialFocus: ".euiFieldText",
    "aria-label": title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, subheading)), description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.prompt', {
      defaultMessage: 'Type "{target}" to confirm.',
      values: {
        target
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "GenericConfirmationModalInput",
    value: inputValue,
    onChange: e => setInputValue(e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "GenericConfirmationModalCancel",
    onClick: onClose
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "GenericConfirmationModalSave",
    onClick: onConfirm,
    disabled: inputValue.toLowerCase() !== target.toLowerCase()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.save', {
    defaultMessage: 'Save setting'
  }))));
};
exports.GenericConfirmationModal = GenericConfirmationModal;