"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchUILogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _engine = require("../engine");
var _i18n = require("./i18n");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchUILogic = exports.SearchUILogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'search_ui_logic'],
  actions: () => ({
    loadFieldData: () => true,
    onFieldDataLoaded: initialFieldValues => initialFieldValues,
    onActiveFieldChange: activeField => ({
      activeField
    }),
    onFacetFieldsChange: facetFields => ({
      facetFields
    }),
    onSortFieldsChange: sortFields => ({
      sortFields
    }),
    onTitleFieldChange: titleField => ({
      titleField
    }),
    onUrlFieldChange: urlField => ({
      urlField
    }),
    onThumbnailFieldChange: thumbnailField => ({
      thumbnailField
    })
  }),
  reducers: () => ({
    dataLoading: [true, {
      onFieldDataLoaded: () => false
    }],
    validFields: [[], {
      onFieldDataLoaded: (_, {
        validFields
      }) => validFields
    }],
    validSortFields: [[], {
      onFieldDataLoaded: (_, {
        validSortFields
      }) => validSortFields
    }],
    validFacetFields: [[], {
      onFieldDataLoaded: (_, {
        validFacetFields
      }) => validFacetFields
    }],
    titleField: ['', {
      onTitleFieldChange: (_, {
        titleField
      }) => titleField,
      onFieldDataLoaded: (_, {
        titleField
      }) => titleField || ''
    }],
    urlField: ['', {
      onUrlFieldChange: (_, {
        urlField
      }) => urlField,
      onFieldDataLoaded: (_, {
        urlField
      }) => urlField || ''
    }],
    thumbnailField: ['', {
      onThumbnailFieldChange: (_, {
        thumbnailField
      }) => thumbnailField
    }],
    facetFields: [[], {
      onFacetFieldsChange: (_, {
        facetFields
      }) => facetFields
    }],
    sortFields: [[], {
      onSortFieldsChange: (_, {
        sortFields
      }) => sortFields
    }],
    activeField: [_types.ActiveField.None, {
      onActiveFieldChange: (_, {
        activeField
      }) => activeField
    }]
  }),
  listeners: ({
    actions
  }) => ({
    loadFieldData: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        searchKey,
        engineName
      } = _engine.EngineLogic.values;
      if (!searchKey) {
        (0, _flash_messages.setErrorMessage)((0, _i18n.NO_SEARCH_KEY_ERROR)(engineName));
        return;
      }
      const url = `/internal/app_search/engines/${engineName}/search_ui/field_config`;
      try {
        const initialFieldValues = await http.get(url);
        const {
          defaultValues: {
            urlField,
            titleField
          },
          validFields,
          validSortFields,
          validFacetFields
        } = initialFieldValues;
        actions.onFieldDataLoaded({
          validFields,
          validSortFields,
          validFacetFields,
          urlField,
          titleField
        });
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});