"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchUIGraphic = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _search_ui_logic = require("../search_ui_logic");
require("./search_ui_graphic.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchUIGraphic = () => {
  const {
    activeField
  } = (0, _kea.useValues)(_search_ui_logic.SearchUILogic);
  const svgClass = 'searchUIGraphic';
  return /*#__PURE__*/_react.default.createElement("svg", {
    className: `${svgClass} active${activeField}`,
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    viewBox: "0 0 587 466"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "search-area"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M39,0h527c2.2,0,4,1.8,4,4v71c0,2.2-1.8,4-4,4H39c-2.2,0-4-1.8-4-4V4C35,1.8,36.8,0,39,0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "field",
    d: "M73.5,23.5h456c8.3,0,15,6.7,15,15l0,0c0,8.3-6.7,15-15,15h-456c-8.3,0-15-6.7-15-15l0,0 C58.5,30.2,65.2,23.5,73.5,23.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "searchIcon",
    d: "M82.5,42.3c2.8,0,5-2.2,5-5c0-2.8-2.2-5-5-5c-2.8,0-5,2.2-5,5C77.5,40,79.7,42.3,82.5,42.3z M78.5,42.2 C78.5,42.2,78.5,42.2,78.5,42.2l-4.4,4.4c-0.3,0.3-0.7,0.3-0.9,0c-0.3-0.3-0.3-0.7,0-0.9l4.4-4.4c0,0,0,0,0.1-0.1 c-0.9-1.1-1.4-2.5-1.4-4c0-3.5,2.8-6.3,6.3-6.3s6.3,2.8,6.3,6.3s-2.8,6.3-6.3,6.3C81,43.6,79.6,43.1,78.5,42.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "type",
    d: "M100.4,42.1c-0.9,0-1.5-0.4-1.5-1.2c0-0.7,0.5-1.1,1.6-1.2l2-0.1v0.7C102.5,41.3,101.6,42.1,100.4,42.1z M100.2,43.1c1,0,1.8-0.4,2.3-1.2h0.1V43h1.1v-5c0-1.5-1-2.5-2.8-2.5c-1.6,0-2.7,0.8-2.9,2h1.2c0.2-0.6,0.8-0.9,1.7-0.9 c1.1,0,1.7,0.5,1.7,1.4v0.7l-2.1,0.1c-1.7,0.1-2.7,0.9-2.7,2.2C97.7,42.3,98.7,43.1,100.2,43.1z M106.2,33.7v1.9H105v1h1.2v4.5 c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6v-1h-1.6v-1.9H106.2z M110.7,43h1.2 v-4.4c0-1.2,0.7-2.1,2-2.1c1.1,0,1.7,0.6,1.7,2V43h1.2v-4.8c0-1.7-1-2.7-2.5-2.7c-1.1,0-1.9,0.5-2.3,1.3h-0.1v-4.1h-1.2V43z M118.9,43h1.2V32.7h-1.2V43z M125.1,36.5c1.2,0,1.9,0.9,2,2.2h-4.1C123.1,37.4,124,36.5,125.1,36.5z M127.1,41.1 c-0.3,0.6-1,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8 c1.6,0,2.7-0.8,3.1-2H127.1z M130.5,33.7v1.9h-1.2v1h1.2v4.5c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0 c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6v-1h-1.6v-1.9H130.5z M135,43h1.2v-7.4H135V43z M135.6,34.1c0.5,0,0.8-0.4,0.8-0.8 c0-0.5-0.4-0.8-0.8-0.8c-0.5,0-0.8,0.4-0.8,0.8C134.8,33.8,135.2,34.1,135.6,34.1z M144.4,37.9c-0.2-1.3-1.3-2.4-3.1-2.4 c-2.1,0-3.4,1.5-3.4,3.8c0,2.3,1.3,3.8,3.4,3.8c1.8,0,2.9-1,3.1-2.4h-1.2c-0.2,0.8-0.9,1.3-1.9,1.3c-1.3,0-2.2-1.1-2.2-2.8 c0-1.7,0.8-2.7,2.2-2.7c1.1,0,1.7,0.6,1.9,1.3H144.4z M149.6,37.6c0,1.1,0.6,1.7,2,2l1.3,0.3c0.8,0.2,1.2,0.5,1.2,1 c0,0.7-0.7,1.1-1.7,1.1c-0.9,0-1.5-0.4-1.7-1h-1.2c0.1,1.2,1.3,2,2.9,2c1.7,0,3-0.9,3-2.2c0-1.1-0.7-1.7-2.1-2l-1.1-0.3 c-0.9-0.2-1.3-0.5-1.3-1c0-0.7,0.7-1.1,1.6-1.1c0.9,0,1.5,0.4,1.6,1h1.2c-0.2-1.2-1.2-2-2.8-2C150.8,35.5,149.6,36.4,149.6,37.6z M157.1,43h1.2v-4.4c0-1.2,0.7-2.1,2-2.1c1.1,0,1.7,0.6,1.7,2V43h1.2v-4.8c0-1.7-1-2.7-2.5-2.7c-1.1,0-1.9,0.5-2.3,1.3h-0.1v-4.1 h-1.2V43z M168.2,43.1c2.1,0,3.4-1.4,3.4-3.8c0-2.4-1.3-3.8-3.4-3.8c-2.1,0-3.4,1.4-3.4,3.8C164.8,41.7,166.1,43.1,168.2,43.1z M168.2,42.1c-1.4,0-2.2-1-2.2-2.8c0-1.8,0.8-2.8,2.2-2.8c1.4,0,2.2,1,2.2,2.8C170.4,41.1,169.6,42.1,168.2,42.1z M176.2,36.5 c1.2,0,1.9,0.9,2,2.2h-4.1C174.2,37.4,175.1,36.5,176.2,36.5z M178.2,41.1c-0.3,0.6-0.9,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3 v-0.5c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H178.2z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    id: "background",
    className: "st0",
    d: "M87,94h454c2.2,0,4,1.8,4,4v348c0,2.2-1.8,4-4,4H87c-2.2,0-4-1.8-4-4V98C83,95.8,84.8,94,87,94\tz"
  }), /*#__PURE__*/_react.default.createElement("g", {
    id: "results"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "result1"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M215,140.5h352c1.9,0,3.5,1.6,3.5,3.5v66c0,1.9-1.6,3.5-3.5,3.5H215c-1.9,0-3.5-1.6-3.5-3.5v-66 C211.5,142.1,213.1,140.5,215,140.5z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    className: "shoe"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M266.1,158.3c-0.7,0.5-1.4,1.4-1.9,2.4c-0.3,0.5-0.5,1-0.6,1.1c-0.3,0.2-0.5,0.7-0.5,1.1 c0,0.3-0.1,0.5-0.4,0.7c-0.7,0.6-1.4,2-1.8,3.5c-0.1,0.3-0.2,0.5-0.5,0.6c-0.6,0.3-0.8,0.7-0.8,1.5c0,0.7,0,0.7-0.4,1 c-0.2,0.1-0.5,0.3-0.5,0.3c-0.2,0-0.8,0.5-1,0.9c-0.2,0.5-1.1,1.2-1.6,1.2c-0.4,0.1-1,0.4-1.1,0.7c-0.1,0.3-1.7,0.9-2.4,0.9 c-0.4,0-0.9,0.2-1.3,0.5c-0.2,0.2-1.6,0.7-2,0.7c-0.4,0-0.7,0.1-1.1,0.5c-0.4,0.4-1.7,0.8-2.4,0.9c-0.5,0-0.6,0.1-1.1,0.6 c-0.3,0.3-0.6,0.7-0.6,0.9c-0.1,0.2-0.1,0.4-0.1,0.5c0,0-0.5,0.1-1.1,0.2c-1.6,0.3-4.2,0.6-7,0.8c-2.8,0.2-3.2,0.3-3.8,0.7 c-0.6,0.5-1.3,1.9-1.3,2.8c0,0.2-0.1,0.3-0.1,0.3c-0.3,0.1-0.5,0.6-0.6,1.5c-0.2,1.6,0,2.4,1.2,3.5c1.9,1.8,6.3,3,12.2,3.6 c0.7,0.1,1.5,0.2,1.8,0.3c0.3,0.1,0.8,0.2,1.1,0.2c1.6,0,3,0.1,3.6,0.1c0.4,0.1,0.8,0,1.1-0.1c0.4-0.1,0.5-0.1,0.8,0.1 c0.5,0.2,3.4,0.3,4.1,0.1c0.4-0.1,0.6-0.1,1.1,0c0.3,0.1,0.7,0.1,0.8,0c0.1,0,0.8-0.1,1.5-0.1c0.7,0,1.4,0,1.6-0.1 c0.2,0,0.6,0,0.9,0c0.3,0,3.1,0,6.2,0c3.1,0,5.8,0,6,0c0.6,0,4.2-0.2,4.3-0.2c0.1,0,0.6-0.1,1.2-0.1c2.3-0.1,2.9-0.1,3.2-0.3 c0.2-0.1,0.5-0.2,0.7-0.2c0.6,0,1.5-0.6,1.6-1.2c0-0.2,0.1-1.4,0.1-2.6c0-2.1,0-2.3-0.1-2.6c-0.2-0.3-0.2-0.4-0.1-0.8 c0.2-0.7,0.2-4.6,0.1-6.4c-0.1-1.8-0.4-3.9-0.8-5.9c-0.3-1.8-1.3-5.5-1.5-5.9c-0.2-0.5-0.5-0.6-1.3-0.4 c-1.5,0.3-4.3-0.2-6.9-1.4l-0.9-0.4l-0.2-0.8c-0.3-1.2-1.2-2.4-2.8-3.6c-1.3-1-3.3-2.2-3.7-2.2 C266.6,158,266.4,158.1,266.1,158.3z M267.7,158.8c2.8,1.6,4.9,3.5,5.2,4.9c0.1,0.3,0,0.3-0.6-0.3c-0.4-0.3-1.1-0.8-1.5-1 c-0.7-0.4-0.9-0.4-1.7-0.4c-0.8,0-1,0-1.5,0.3c-0.7,0.4-1.6,1.2-2.3,2.1c-0.2,0.4-0.8,1.1-1.3,1.5c-0.8,0.8-1.3,1.7-1.3,2.1 c0,0.2,0,0.2-0.6-0.1c-0.3-0.2-0.6-0.3-0.7-0.3c-0.2,0-0.2-0.3,0-1.1c0.4-1.4,1.1-2.5,1.7-2.9c0.3-0.2,0.3-0.3,0.3-0.4 c-0.1-0.4,0.1-1,0.4-1.3c0.2-0.2,0.4-0.6,0.6-1c0.4-0.9,1.2-2,1.8-2.4c0.3-0.2,0.5-0.3,0.6-0.3 C266.8,158.3,267.3,158.5,267.7,158.8z M268.8,163.7c0,0.3-0.2,0.4-0.4,0.2c-0.1-0.1-0.1-0.2,0-0.3 C268.4,163.4,268.7,163.5,268.8,163.7z M267.4,165.1c0.4,0.2,3.4,2.3,5.1,3.6c2.2,1.7,4.2,3.5,6.4,5.6c2.9,2.9,3.8,3.6,5.1,3.7 l0.6,0.1l0.1,2c0.1,3-0.1,5.2-0.6,5.6c-0.6,0.5-2.3,0.7-7.3,0.9c-1.7,0.1-3.7,0.1-4.4,0.2l-1.2,0.1l0.2-0.6 c0.1-0.4,0.3-1.2,0.4-1.8c0.7-4.6-1.2-9.2-5-12.5c-1.9-1.7-3.4-3-3.5-3.2c-0.1-0.3,0.3-1.2,0.8-1.8 C265.1,165.2,266.3,164.6,267.4,165.1z M261.8,168.1c0.5,0.2,0.8,0.4,1.5,1.1c0.5,0.5,1.2,1.2,1.6,1.5l0.7,0.6v0.6 c0,0.8-0.1,1.3-0.5,1.7c-0.3,0.3-1.4,0.7-8.8,3.2c-4.6,1.6-8.8,3-9.2,3.1c-0.4,0.1-1.1,0.2-1.5,0.2c-0.7,0-0.7,0-0.9-0.2 c-0.1-0.2-0.2-0.5-0.2-0.9c0-0.8,0.2-1.1,0.3-0.5c0.2,0.6,0.6,0.9,1,0.9c0.6,0,0.7-0.4,0.7-1.4l0-0.8l0.8-0.3 c0.5-0.2,0.8-0.3,0.9-0.3c0,0,0.1,0.3,0.1,0.5c0.1,0.6,0.4,1.2,0.7,1.3c0.3,0.1,0.8-0.1,0.9-0.5c0.1-0.3,0.1-1.1-0.1-1.8 c-0.1-0.2,0-0.3,0.8-0.6l0.9-0.3l0.1,0.4c0.2,0.6,0.5,1.2,0.7,1.3c0.4,0.2,0.8,0.1,1-0.1c0.2-0.3,0.2-1.1,0-1.7 c-0.1-0.2-0.1-0.5-0.1-0.5c0.1-0.1,1.7-0.6,1.7-0.6c0,0,0.1,0.3,0.3,0.7c0.3,0.8,0.7,1.2,1.1,1.2c0.8,0,1-0.9,0.5-2.4l-0.2-0.6 l0.5-0.5c0.3-0.2,0.5-0.4,0.6-0.3c0.1,0.2,0.8,1.4,1,1.6c0.1,0.1,0.4,0.3,0.5,0.4c0.3,0.1,0.3,0.1,0.5,0c0.5-0.3,0.5-1.1,0-2.2 c-0.2-0.4-0.4-0.8-0.5-0.9c-0.2-0.3-0.2-0.3,0.1-0.6c0.2-0.2,0.4-0.3,0.5-0.3c0.1,0,0.4,0.4,0.8,0.8c1,1.4,2.1,2,2.7,1.7 c0.3-0.2,0.3-0.4,0-1c-0.4-0.8-2.2-3.2-2.6-3.6c-0.1-0.1-0.1-0.1,0-0.2C261.1,167.9,261.2,167.9,261.8,168.1z M244.2,179.4 c0.1,0.5,0.3,0.9,0.6,1c0.3,0.1,1.3,2.1,1.5,3c0.2,0.7,0,1-0.5,1.4c-0.7,0.4-1.4,0.1-2.5-0.9c-1.2-1.2-2.5-1.6-5.4-1.8 c-1.7-0.2-3.1-0.4-3.7-0.7c-0.4-0.2-0.9-0.7-0.9-0.8c0-0.1,0.7-0.2,2.6-0.3c2.6-0.2,6-0.6,7.3-0.9c0.4-0.1,0.8-0.1,0.8-0.2 C244.1,179.2,244.1,179.3,244.2,179.4z M231.3,184.3c0.5,0.5,2,1.3,3.2,1.7c1.8,0.6,3.7,1,6.5,1.3c4.8,0.6,7.7,0.8,11.9,0.8 c4,0,4.9-0.1,12.9-0.7c1-0.1,2.7-0.2,3.7-0.2c1.9-0.1,2.8-0.2,8.3-0.3c4.1-0.1,5.6-0.4,6.5-0.9c0.1-0.1,0.3-0.1,0.3-0.1 c0.1,0.1,0,4.8-0.1,5.1c-0.1,0.4-0.7,0.7-1.2,0.7c-0.2,0-0.6,0.1-0.8,0.2c-0.4,0.2-0.8,0.2-3,0.3c-0.5,0-1.5,0.1-2,0.1 c-0.6,0-2.6,0.1-4.5,0.1s-3.6,0-3.8,0c-0.2,0-1.1,0-1.9,0c-0.8,0-1.8,0-2,0c-0.8,0-1.7,0-2,0c-0.1,0-0.6,0-0.9,0.1 c-0.4,0-0.8,0-1-0.1c-0.3-0.1-0.4-0.1-0.7,0.1c-0.3,0.1-0.5,0.2-1.1,0.1c-0.4,0-0.8-0.1-0.8-0.1c-0.8,0.1-1.5,0.1-1.9,0 c-0.4-0.1-0.5-0.1-0.6,0c-0.2,0.2-3.5,0.2-4.2,0c-0.4-0.2-0.5-0.2-1.1,0c-0.5,0.1-0.7,0.1-1.2,0c-0.5-0.1-0.7-0.1-0.9-0.1 c-0.2,0.1-0.6,0.1-0.9,0c-0.3,0-0.9-0.1-1.2-0.1c-0.3,0-0.9-0.1-1.3-0.2c-0.4-0.1-1-0.2-1.3-0.2c-1,0-4.6-0.5-6.6-1 c-2.5-0.6-4.9-1.6-5.9-2.6c-0.7-0.7-0.9-1.1-1-1.9c-0.1-0.8,0.2-2.5,0.4-2.5C230.8,183.9,231,184.1,231.3,184.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M265.9,165.8c-0.3,0.3-0.1,0.7,0.4,0.7c0.3,0,0.4-0.4,0.2-0.7C266.3,165.6,266.1,165.6,265.9,165.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M264.3,167.6c-0.1,0.2-0.1,0.6,0.1,0.7c0.4,0.2,0.7-0.1,0.6-0.6C264.9,167.6,264.4,167.5,264.3,167.6z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    className: "url",
    d: "M304.8,188h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9 c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V188z M311,181.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7 c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H311z M314.5,181.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4 c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H314.5z M320.3,182.6 c-0.7,0-1.3,0.4-1.7,1h-0.1v-0.9h-0.8v7h0.8v-2.5h0.1c0.3,0.6,0.9,0.9,1.6,0.9c1.3,0,2.2-1.1,2.2-2.7 C322.5,183.7,321.6,182.6,320.3,182.6z M320.1,187.3c-0.9,0-1.5-0.8-1.5-2c0-1.2,0.6-2,1.6-2c1,0,1.5,0.7,1.5,2 C321.6,186.6,321,187.3,320.1,187.3z M323.6,184.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8 c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.7,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2 c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C324.4,182.6,323.6,183.3,323.6,184.2z M329.5,188c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,187.8,329.2,188,329.5,188z M329.5,184.3c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,184,329.2,184.3,329.5,184.3z M331.6,189.5l2.6-8.9h-0.7l-2.6,8.9H331.6z M334.9,189.5l2.6-8.9h-0.7l-2.6,8.9H334.9z M338,184.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.7,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C338.9,182.6,338,183.3,338,184.2z M343.3,188h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5 c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V188z M351.3,188.1 c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7C348.9,187.1,349.8,188.1,351.3,188.1z M351.3,187.3 c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2s1.6,0.7,1.6,2C352.8,186.6,352.3,187.3,351.3,187.3z M357,183.4c0.8,0,1.4,0.6,1.4,1.5 h-2.9C355.6,184,356.2,183.4,357,183.4z M358.4,186.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3 c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H358.4z M360.4,184.2 c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.7,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C361.3,182.6,360.4,183.3,360.4,184.2z M366.4,188c0.4,0,0.6-0.3,0.6-0.6 c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6C365.7,187.8,366,188,366.4,188z M372.7,184.3c-0.1-0.9-0.9-1.7-2.2-1.7 c-1.5,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.3,0,2.1-0.7,2.2-1.7h-0.8c-0.2,0.6-0.6,0.9-1.4,0.9c-0.9,0-1.5-0.8-1.5-2 c0-1.2,0.6-1.9,1.5-1.9c0.8,0,1.2,0.4,1.4,0.9H372.7z M376,188.1c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7 C373.6,187.1,374.5,188.1,376,188.1z M376,187.3c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2c1,0,1.6,0.7,1.6,2 C377.6,186.6,377,187.3,376,187.3z M379.7,188h0.8v-3.3c0-0.7,0.5-1.3,1.2-1.3c0.7,0,1.1,0.4,1.1,1v3.6h0.8v-3.4 c0-0.7,0.5-1.2,1.2-1.2c0.7,0,1.1,0.4,1.1,1.2v3.4h0.8v-3.6c0-1.1-0.6-1.7-1.7-1.7c-0.7,0-1.3,0.4-1.6,0.9h-0.1 c-0.2-0.5-0.7-0.9-1.5-0.9c-0.7,0-1.2,0.3-1.5,0.9h-0.1v-0.8h-0.8V188z M388.2,189.5l2.6-8.9h-0.7l-2.6,8.9H388.2z M391.5,188h0.8 v-3.1c0-0.9,0.5-1.5,1.4-1.5c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.3,0.3-1.6,0.9h-0.1v-0.8h-0.8 V188z M397.2,188h0.8v-5.3h-0.8V188z M397.7,181.7c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C397.1,181.4,397.3,181.7,397.7,181.7z M400.6,185L400.6,185l-0.1-4.4h-0.8v7.4h0.8v-2l0.5-0.5l2,2.5h1.1l-2.4-3l2.3-2.3h-1 L400.6,185z M406.8,183.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C405.3,184,405.9,183.4,406.8,183.4z M408.2,186.6c-0.2,0.5-0.7,0.7-1.4,0.7 c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5 H408.2z M413.5,185.6v-0.8h-3.2v0.8H413.5z M414.9,188h0.8v-3.3c0-0.7,0.6-1.3,1.4-1.3c0.2,0,0.5,0,0.5,0v-0.8c-0.1,0-0.3,0-0.4,0 c-0.7,0-1.3,0.4-1.5,0.9h-0.1v-0.8h-0.8V188z M420.6,183.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C419.1,184,419.7,183.4,420.6,183.4z M422,186.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7 c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H422z M428.3,182.7h-0.9l-1.4,4.3h-0.1l-1.4-4.3h-0.9l1.9,5.3h0.9L428.3,182.7z M431.3,188.1c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7s-2.4,1-2.4,2.7C428.8,187.1,429.8,188.1,431.3,188.1z M431.3,187.3 c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2s1.6,0.7,1.6,2C432.8,186.6,432.3,187.3,431.3,187.3z M435,188h0.8v-7.4H435V188z M441.6,182.7h-0.8v3.1c0,0.9-0.5,1.5-1.4,1.5c-0.8,0-1.2-0.4-1.2-1.4v-3.2h-0.8v3.4c0,1.2,0.6,1.9,1.8,1.9c0.8,0,1.4-0.3,1.6-0.9 h0.1v0.8h0.8V182.7z M443.4,181.4v1.4h-0.8v0.7h0.8v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0 c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H443.4z M446.6,188h0.8v-5.3h-0.8V188z M447,181.7c0.3,0,0.6-0.3,0.6-0.6 c0-0.3-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6C446.5,181.4,446.7,181.7,447,181.7z M451.1,188.1c1.5,0,2.4-1,2.4-2.7 c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7C448.7,187.1,449.6,188.1,451.1,188.1z M451.1,187.3c-1,0-1.6-0.7-1.6-2 c0-1.2,0.6-2,1.6-2c1,0,1.6,0.7,1.6,2C452.7,186.6,452.1,187.3,451.1,187.3z M454.8,188h0.8v-3.1c0-0.9,0.5-1.5,1.4-1.5 s1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.3,0.3-1.6,0.9h-0.1v-0.8h-0.8V188z M463.7,185.6v-0.8h-3.2v0.8 H463.7z M468.3,188h0.9v-1.5h1v-0.8h-1V181h-1.3c-1.3,1.9-2.4,3.7-3,4.8v0.8h3.4V188z M465.8,185.7c0.8-1.4,1.8-2.9,2.5-3.9h0.1v4 L465.8,185.7L465.8,185.7z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleBox",
    d: "M300,153.5h231c1.9,0,3.5,1.6,3.5,3.5v14c0,1.9-1.6,3.5-3.5,3.5H300c-1.9,0-3.5-1.6-3.5-3.5v-14 C296.5,155.1,298.1,153.5,300,153.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleCopy",
    d: "M306.3,168v-6h0.1l4.3,6h1.2v-8.5h-1.3v6h-0.1l-4.3-6h-1.2v8.5H306.3z M313.8,168h1.3v-6.4h-1.3V168z M314.5,160.5c0.5,0,0.8-0.3,0.8-0.8c0-0.4-0.3-0.8-0.8-0.8c-0.5,0-0.8,0.3-0.8,0.8C313.7,160.2,314,160.5,314.5,160.5z M318.2,164.3L318.2,164.3l-0.1-5.2h-1.3v8.9h1.3v-2.3l0.6-0.5l2.2,2.8h1.5l-2.8-3.6l2.6-2.7h-1.5L318.2,164.3z M325.8,162.6 c0.9,0,1.5,0.7,1.6,1.7h-3.2C324.2,163.2,324.8,162.6,325.8,162.6z M327.3,166.3c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8 v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3c1.5,0,2.5-0.7,2.8-1.8H327.3z M334.6,160.7h1.9 c1,0,1.6,0.6,1.6,1.5c0,0.9-0.6,1.5-1.6,1.5h-1.9V160.7z M334.6,164.8h1.9l1.7,3.2h1.5l-1.9-3.4c1-0.4,1.6-1.3,1.6-2.4 c0-1.6-1.1-2.6-2.8-2.6h-3.3v8.5h1.3V164.8z M343.5,162.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C341.9,163.2,342.6,162.6,343.5,162.6z M345.1,166.3c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3 s1.1,3.3,2.9,3.3c1.5,0,2.5-0.7,2.8-1.8H345.1z M353,161.6h-1.3l-1.6,5H350l-1.6-5h-1.3l2.3,6.4h1.4L353,161.6z M356.6,168.1 c1.9,0,3-1.2,3-3.3c0-2.1-1.1-3.3-3-3.3c-1.9,0-3,1.3-3,3.3C353.6,166.9,354.7,168.1,356.6,168.1z M356.6,167 c-1.1,0-1.7-0.8-1.7-2.2c0-1.4,0.6-2.2,1.7-2.2c1.1,0,1.7,0.8,1.7,2.2C358.3,166.2,357.7,167,356.6,167z M361.1,168h1.3v-8.9h-1.3 V168z M369.5,161.6h-1.3v3.7c0,1-0.6,1.6-1.6,1.6c-0.9,0-1.3-0.5-1.3-1.5v-3.8h-1.3v4.1c0,1.5,0.8,2.4,2.2,2.4 c1,0,1.6-0.4,1.9-1.1h0.1v1h1.2V161.6z M371.6,160v1.6h-1v1.1h1v3.6c0,1.2,0.6,1.7,2,1.7c0.2,0,0.5,0,0.7-0.1v-1 c-0.2,0-0.3,0-0.5,0c-0.6,0-0.9-0.3-0.9-1v-3.3h1.4v-1.1h-1.4V160H371.6z M375.7,168h1.3v-6.4h-1.3V168z M376.3,160.5 c0.5,0,0.8-0.3,0.8-0.8c0-0.4-0.3-0.8-0.8-0.8c-0.5,0-0.8,0.3-0.8,0.8C375.5,160.2,375.8,160.5,376.3,160.5z M381.4,168.1 c1.9,0,3-1.2,3-3.3c0-2.1-1.1-3.3-3-3.3c-1.9,0-3,1.3-3,3.3C378.3,166.9,379.5,168.1,381.4,168.1z M381.4,167 c-1.1,0-1.7-0.8-1.7-2.2c0-1.4,0.6-2.2,1.7-2.2c1.1,0,1.7,0.8,1.7,2.2C383.1,166.2,382.4,167,381.4,167z M385.8,168h1.3v-3.7 c0-1,0.6-1.6,1.5-1.6c0.9,0,1.4,0.5,1.4,1.5v3.8h1.3v-4.1c0-1.5-0.8-2.4-2.2-2.4c-1,0-1.6,0.4-1.9,1.1H387v-1h-1.2V168z M399.9,168h1.3v-1.6h1.2v-1.2h-1.2v-5.6h-1.9c-1.5,2.3-2.8,4.2-3.5,5.6v1.2h4.1V168z M397,165.1c1-1.7,2-3.2,2.8-4.4h0.1v4.5 L397,165.1L397,165.1z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    id: "result2"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M215,224.5h352c1.9,0,3.5,1.6,3.5,3.5v66c0,1.9-1.6,3.5-3.5,3.5H215c-1.9,0-3.5-1.6-3.5-3.5v-66 C211.5,226.1,213.1,224.5,215,224.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "url",
    d: "M304.8,270h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9 c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V270z M311,263.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7 c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H311z M314.5,263.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4 c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H314.5z M320.3,264.6 c-0.7,0-1.3,0.4-1.7,1h-0.1v-0.9h-0.8v7h0.8v-2.5h0.1c0.3,0.6,0.9,0.9,1.6,0.9c1.3,0,2.2-1.1,2.2-2.7 C322.5,265.7,321.6,264.6,320.3,264.6z M320.1,269.3c-0.9,0-1.5-0.8-1.5-2c0-1.2,0.6-2,1.6-2c1,0,1.5,0.7,1.5,2 C321.6,268.6,321,269.3,320.1,269.3z M323.6,266.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8 c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2 c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C324.4,264.6,323.6,265.3,323.6,266.2z M329.5,270c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,269.8,329.2,270,329.5,270z M329.5,266.3c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,266,329.2,266.3,329.5,266.3z M331.6,271.5l2.6-8.9h-0.7l-2.6,8.9H331.6z M334.9,271.5l2.6-8.9h-0.7l-2.6,8.9H334.9z M338,266.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C338.9,264.6,338,265.3,338,266.2z M343.3,270h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5 c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V270z M351.3,270.1 c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7C348.9,269.1,349.8,270.1,351.3,270.1z M351.3,269.3 c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2s1.6,0.7,1.6,2C352.8,268.6,352.3,269.3,351.3,269.3z M357,265.4c0.8,0,1.4,0.6,1.4,1.5 h-2.9C355.6,266,356.2,265.4,357,265.4z M358.4,268.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3 c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H358.4z M360.4,266.2 c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C361.3,264.6,360.4,265.3,360.4,266.2z M366.4,270c0.4,0,0.6-0.3,0.6-0.6 c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6C365.7,269.8,366,270,366.4,270z M372.7,266.3c-0.1-0.9-0.9-1.7-2.2-1.7 c-1.5,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.3,0,2.1-0.7,2.2-1.7h-0.8c-0.2,0.6-0.6,0.9-1.4,0.9c-0.9,0-1.5-0.8-1.5-2 c0-1.2,0.6-1.9,1.5-1.9c0.8,0,1.2,0.4,1.4,0.9H372.7z M376,270.1c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7 C373.6,269.1,374.5,270.1,376,270.1z M376,269.3c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2c1,0,1.6,0.7,1.6,2 C377.6,268.6,377,269.3,376,269.3z M379.7,270h0.8v-3.3c0-0.7,0.5-1.3,1.2-1.3c0.7,0,1.1,0.4,1.1,1v3.6h0.8v-3.4 c0-0.7,0.5-1.2,1.2-1.2c0.7,0,1.1,0.4,1.1,1.2v3.4h0.8v-3.6c0-1.1-0.6-1.7-1.7-1.7c-0.7,0-1.3,0.4-1.6,0.9h-0.1 c-0.2-0.5-0.7-0.9-1.5-0.9c-0.7,0-1.2,0.3-1.5,0.9h-0.1v-0.8h-0.8V270z M388.2,271.5l2.6-8.9h-0.7l-2.6,8.9H388.2z M393.1,269.4 c-0.6,0-1.1-0.3-1.1-0.8c0-0.5,0.4-0.8,1.2-0.9l1.4-0.1v0.5C394.6,268.8,394,269.4,393.1,269.4z M393,270.1c0.7,0,1.3-0.3,1.6-0.9 h0.1v0.8h0.8v-3.6c0-1.1-0.7-1.8-2-1.8c-1.1,0-2,0.6-2.1,1.4h0.8c0.1-0.4,0.6-0.7,1.2-0.7c0.8,0,1.2,0.4,1.2,1v0.5l-1.5,0.1 c-1.2,0.1-1.9,0.6-1.9,1.6C391.2,269.5,391.9,270.1,393,270.1z M396.8,266.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2 c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6 c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C397.6,264.6,396.8,265.3,396.8,266.2z M402.1,270h0.8v-5.3h-0.8V270z M402.5,263.7c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6 c-0.3,0-0.6,0.3-0.6,0.6C401.9,263.4,402.2,263.7,402.5,263.7z M408.8,266.3c-0.1-0.9-0.9-1.7-2.2-1.7c-1.5,0-2.4,1.1-2.4,2.7 c0,1.7,0.9,2.7,2.4,2.7c1.3,0,2.1-0.7,2.2-1.7h-0.8c-0.2,0.6-0.6,0.9-1.4,0.9c-0.9,0-1.5-0.8-1.5-2c0-1.2,0.6-1.9,1.5-1.9 c0.8,0,1.2,0.4,1.4,0.9H408.8z M409.8,266.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8 c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2 c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C410.6,264.6,409.8,265.3,409.8,266.2z M418.2,267.6v-0.8H415v0.8H418.2z M421.8,269.2c-1,0-1.5-0.7-1.5-1.9 c0-1.1,0.5-1.9,1.5-1.9c1,0,1.6,0.7,1.6,1.9C423.3,268.4,422.8,269.2,421.8,269.2z M421.8,272c1.4,0,2.3-0.8,2.3-1.9v-5.4h-0.8 v0.8h-0.1c-0.3-0.6-1-0.9-1.7-0.9c-1.4,0-2.2,1.1-2.2,2.6s0.8,2.6,2.2,2.6c0.7,0,1.3-0.3,1.7-0.9h0.1v1c0,0.8-0.6,1.2-1.5,1.2 c-0.8,0-1.2-0.3-1.3-0.7h-0.9C419.7,271.5,420.5,272,421.8,272z M427.7,265.4c0.8,0,1.4,0.6,1.4,1.5h-2.9 C426.3,266,426.9,265.4,427.7,265.4z M429.1,268.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3 c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H429.1z M431.3,270h0.8v-7.4h-0.8V270z M436.8,267.6v-0.8h-3.2v0.8H436.8z M442.5,264.7h-0.9l-1.4,4.3h-0.1l-1.4-4.3h-0.9l1.9,5.3h0.9L442.5,264.7z M445.4,265.4 c0.8,0,1.4,0.6,1.4,1.5h-2.9C444,266,444.6,265.4,445.4,265.4z M446.8,268.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0 h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H446.8z M448.9,270h0.8v-3.1 c0-0.9,0.5-1.5,1.4-1.5c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.3,0.3-1.6,0.9h-0.1v-0.8h-0.8V270z M455,263.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2 v-0.7h-1.2v-1.4H455z M462.5,264.7h-0.8v3.1c0,0.9-0.5,1.5-1.4,1.5c-0.8,0-1.2-0.4-1.2-1.4v-3.2h-0.8v3.4c0,1.2,0.6,1.9,1.8,1.9 c0.8,0,1.4-0.3,1.6-0.9h0.1v0.8h0.8V264.7z M463.9,270h0.8v-3.3c0-0.7,0.6-1.3,1.4-1.3c0.2,0,0.5,0,0.5,0v-0.8c-0.1,0-0.3,0-0.4,0 c-0.7,0-1.3,0.4-1.5,0.9h-0.1v-0.8h-0.8V270z M469.6,265.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C468.2,266,468.8,265.4,469.6,265.4z M471,268.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7 c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H471z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    className: "shoe"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M266.1,242.3c-0.7,0.5-1.4,1.4-1.9,2.4c-0.3,0.5-0.5,1-0.6,1.1c-0.3,0.2-0.5,0.7-0.5,1.1 c0,0.3-0.1,0.5-0.4,0.7c-0.7,0.6-1.4,2-1.8,3.5c-0.1,0.3-0.2,0.5-0.5,0.6c-0.6,0.3-0.8,0.7-0.8,1.5c0,0.7,0,0.7-0.4,1 c-0.2,0.1-0.5,0.3-0.5,0.3c-0.2,0-0.8,0.5-1,0.9c-0.2,0.5-1.1,1.2-1.6,1.2c-0.4,0.1-1,0.4-1.1,0.7c-0.1,0.3-1.7,0.9-2.4,0.9 c-0.4,0-0.9,0.2-1.3,0.5c-0.2,0.2-1.6,0.7-2,0.7c-0.4,0-0.7,0.1-1.1,0.5c-0.4,0.4-1.7,0.8-2.4,0.9c-0.5,0-0.6,0.1-1.1,0.6 c-0.3,0.3-0.6,0.7-0.6,0.9c-0.1,0.2-0.1,0.4-0.1,0.5c0,0-0.5,0.1-1.1,0.2c-1.6,0.3-4.2,0.6-7,0.8c-2.8,0.2-3.2,0.3-3.8,0.7 c-0.6,0.5-1.3,1.9-1.3,2.8c0,0.1-0.1,0.3-0.1,0.3c-0.3,0.1-0.5,0.6-0.6,1.5c-0.2,1.6,0,2.4,1.2,3.5c1.9,1.8,6.3,3,12.2,3.6 c0.7,0.1,1.5,0.2,1.8,0.3c0.3,0.1,0.8,0.2,1.1,0.2c1.6,0,3,0.1,3.6,0.1c0.4,0.1,0.8,0,1.1,0c0.4-0.1,0.5-0.1,0.8,0 c0.5,0.2,3.4,0.3,4.1,0.1c0.4-0.1,0.6-0.1,1.1,0c0.3,0.1,0.7,0.1,0.8,0c0.1,0,0.8-0.1,1.5-0.1c0.7,0,1.4,0,1.6,0 c0.2,0,0.6,0,0.9,0c0.3,0,3.1,0,6.2,0c3.1,0,5.8,0,6,0c0.6,0,4.2-0.1,4.3-0.2c0.1,0,0.6-0.1,1.2-0.1c2.3-0.1,2.9-0.1,3.2-0.3 c0.2-0.1,0.5-0.2,0.7-0.2c0.6,0,1.5-0.6,1.6-1.2c0-0.2,0.1-1.4,0.1-2.6c0-2.1,0-2.3-0.1-2.6c-0.2-0.3-0.2-0.4-0.1-0.8 c0.2-0.7,0.2-4.6,0.1-6.4c-0.1-1.8-0.4-3.9-0.8-5.9c-0.3-1.8-1.3-5.5-1.5-5.9c-0.2-0.5-0.5-0.6-1.3-0.4 c-1.5,0.3-4.3-0.2-6.9-1.4l-0.9-0.4l-0.2-0.8c-0.3-1.2-1.2-2.4-2.8-3.6c-1.3-1-3.3-2.2-3.7-2.2 C266.6,242,266.4,242.1,266.1,242.3z M267.7,242.8c2.8,1.6,4.9,3.5,5.2,4.9c0.1,0.3,0,0.3-0.6-0.3c-0.4-0.3-1.1-0.8-1.5-1 c-0.7-0.4-0.9-0.4-1.7-0.4c-0.8,0-1,0-1.5,0.3c-0.7,0.4-1.6,1.2-2.3,2.1c-0.2,0.4-0.8,1.1-1.3,1.5c-0.8,0.8-1.3,1.7-1.3,2.1 c0,0.2,0,0.2-0.6-0.1c-0.3-0.2-0.6-0.3-0.7-0.3c-0.2,0-0.2-0.3,0-1.1c0.4-1.4,1.1-2.5,1.7-2.9c0.3-0.2,0.3-0.3,0.3-0.4 c-0.1-0.4,0.1-1,0.4-1.3c0.2-0.2,0.4-0.6,0.6-1c0.4-0.9,1.2-2,1.8-2.4c0.3-0.2,0.5-0.3,0.6-0.3 C266.8,242.3,267.3,242.5,267.7,242.8z M268.8,247.7c0,0.3-0.2,0.4-0.4,0.2c-0.1-0.1-0.1-0.2,0-0.3 C268.4,247.4,268.7,247.5,268.8,247.7z M267.4,249.1c0.4,0.2,3.4,2.3,5.1,3.6c2.2,1.7,4.2,3.5,6.4,5.6c2.9,2.9,3.8,3.6,5.1,3.7 l0.6,0.1l0.1,2c0.1,3-0.1,5.2-0.6,5.6c-0.6,0.5-2.3,0.7-7.3,0.9c-1.7,0.1-3.7,0.1-4.4,0.2l-1.2,0.1l0.2-0.6 c0.1-0.4,0.3-1.2,0.4-1.8c0.7-4.6-1.2-9.2-5-12.5c-1.9-1.7-3.4-3-3.5-3.2c-0.1-0.3,0.3-1.2,0.8-1.8 C265.1,249.2,266.3,248.6,267.4,249.1z M261.8,252.1c0.5,0.2,0.8,0.4,1.5,1.1c0.5,0.5,1.2,1.2,1.6,1.5l0.7,0.6v0.6 c0,0.8-0.1,1.3-0.5,1.7c-0.3,0.3-1.4,0.7-8.8,3.2c-4.6,1.6-8.8,3-9.2,3.1c-0.4,0.1-1.1,0.2-1.5,0.2c-0.7,0-0.7,0-0.9-0.2 c-0.1-0.2-0.2-0.5-0.2-0.9c0-0.8,0.2-1.1,0.3-0.5c0.2,0.6,0.6,0.9,1,0.9c0.6,0,0.7-0.4,0.7-1.4l0-0.8l0.8-0.3 c0.5-0.2,0.8-0.3,0.9-0.3c0,0,0.1,0.3,0.1,0.5c0.1,0.6,0.4,1.2,0.7,1.3c0.3,0.1,0.8-0.1,0.9-0.5c0.1-0.3,0.1-1.1-0.1-1.8 c-0.1-0.2,0-0.3,0.8-0.6l0.9-0.3l0.1,0.4c0.2,0.6,0.5,1.2,0.7,1.3c0.4,0.2,0.8,0.1,1-0.1c0.2-0.3,0.2-1.1,0-1.7 c-0.1-0.2-0.1-0.5-0.1-0.5c0.1-0.1,1.7-0.6,1.7-0.6c0,0,0.1,0.3,0.3,0.7c0.3,0.8,0.7,1.2,1.1,1.2c0.8,0,1-0.9,0.5-2.4l-0.2-0.6 l0.5-0.5c0.3-0.2,0.5-0.4,0.6-0.3c0.1,0.2,0.8,1.4,1,1.6c0.1,0.1,0.4,0.3,0.5,0.4c0.3,0.1,0.3,0.1,0.5,0c0.5-0.3,0.5-1.1,0-2.2 c-0.2-0.4-0.4-0.8-0.5-0.9c-0.2-0.3-0.2-0.3,0.1-0.6c0.2-0.2,0.4-0.3,0.5-0.3c0.1,0,0.4,0.4,0.8,0.8c1,1.4,2.1,2,2.7,1.7 c0.3-0.2,0.3-0.4,0-1c-0.4-0.8-2.2-3.2-2.6-3.6c-0.1-0.1-0.1-0.1,0-0.2C261.1,251.9,261.2,251.9,261.8,252.1z M244.2,263.4 c0.1,0.5,0.3,0.9,0.6,1c0.3,0.1,1.3,2.1,1.5,3c0.2,0.7,0,1-0.5,1.4c-0.7,0.4-1.4,0.2-2.5-0.9c-1.2-1.2-2.5-1.6-5.4-1.8 c-1.7-0.2-3.1-0.4-3.7-0.7c-0.4-0.2-0.9-0.7-0.9-0.8c0-0.1,0.7-0.2,2.6-0.3c2.6-0.2,6-0.6,7.3-0.9c0.4-0.1,0.8-0.2,0.8-0.2 C244.1,263.2,244.1,263.3,244.2,263.4z M231.3,268.3c0.5,0.5,2,1.3,3.2,1.7c1.8,0.6,3.7,1,6.5,1.3c4.8,0.6,7.7,0.8,11.9,0.8 c4,0,4.9,0,12.9-0.7c1-0.1,2.7-0.2,3.7-0.2c1.9-0.1,2.8-0.2,8.3-0.3c4.1-0.1,5.6-0.4,6.5-0.9c0.1-0.1,0.3-0.1,0.3-0.1 c0.1,0.1,0,4.8-0.1,5.1c-0.1,0.3-0.7,0.7-1.2,0.7c-0.2,0-0.6,0.1-0.8,0.2c-0.4,0.2-0.8,0.2-3,0.3c-0.5,0-1.5,0.1-2,0.1 c-0.6,0-2.6,0.1-4.5,0.1s-3.6,0-3.8,0c-0.2,0-1.1,0-1.9,0c-0.8,0-1.8,0-2,0c-0.8,0-1.7,0-2,0c-0.1,0-0.6,0-0.9,0.1 c-0.4,0-0.8,0-1-0.1c-0.3-0.1-0.4-0.1-0.7,0.1c-0.3,0.1-0.5,0.2-1.1,0.1c-0.4,0-0.8-0.1-0.8-0.1c-0.8,0.1-1.5,0.1-1.9,0 c-0.4-0.1-0.5-0.1-0.6,0c-0.2,0.2-3.5,0.2-4.2,0c-0.4-0.2-0.5-0.2-1.1,0c-0.5,0.1-0.7,0.1-1.2,0c-0.5-0.1-0.7-0.1-0.9-0.1 c-0.2,0.1-0.6,0.1-0.9,0c-0.3,0-0.9-0.1-1.2-0.1c-0.3,0-0.9-0.1-1.3-0.2c-0.4-0.1-1-0.2-1.3-0.2c-1,0-4.6-0.5-6.6-1 c-2.5-0.6-4.9-1.6-5.9-2.6c-0.7-0.7-0.9-1.1-1-1.9c-0.1-0.8,0.2-2.5,0.4-2.5C230.8,267.9,231,268.1,231.3,268.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M265.9,249.8c-0.3,0.3-0.1,0.7,0.4,0.7c0.3,0,0.4-0.4,0.2-0.7C266.3,249.6,266.1,249.6,265.9,249.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M264.3,251.6c-0.1,0.2-0.1,0.6,0.1,0.7c0.4,0.2,0.7-0.1,0.6-0.6C264.9,251.6,264.4,251.5,264.3,251.6z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleBox",
    d: "M300,236.5h231c1.9,0,3.5,1.6,3.5,3.5v14c0,1.9-1.6,3.5-3.5,3.5H300c-1.9,0-3.5-1.6-3.5-3.5v-14 C296.5,238.1,298.1,236.5,300,236.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleCopy",
    d: "M310.5,251h1.4l-3.1-8.5h-1.4l-3.1,8.5h1.3l0.8-2.2h3.2L310.5,251z M308.1,244.1L308.1,244.1l1.3,3.6h-2.6 L308.1,244.1z M312.9,246.4c0,0.9,0.6,1.5,1.8,1.8l1.1,0.3c0.6,0.2,0.9,0.4,0.9,0.8c0,0.5-0.6,0.9-1.3,0.9c-0.8,0-1.2-0.3-1.4-0.8 h-1.3c0.1,1.1,1.1,1.8,2.6,1.8c1.5,0,2.6-0.8,2.6-2c0-0.9-0.6-1.5-1.8-1.7l-1.1-0.2c-0.7-0.2-1-0.4-1-0.8c0-0.5,0.5-0.8,1.2-0.8 c0.7,0,1.2,0.3,1.3,0.8h1.2c-0.1-1.1-1.1-1.8-2.5-1.8C313.9,244.5,312.9,245.3,312.9,246.4z M319.4,251h1.3v-6.4h-1.3V251z M320,243.5c0.5,0,0.8-0.3,0.8-0.8c0-0.4-0.3-0.8-0.8-0.8c-0.5,0-0.8,0.3-0.8,0.8C319.2,243.2,319.5,243.5,320,243.5z M327.8,246.7c-0.2-1.3-1.1-2.2-2.7-2.2c-1.9,0-3,1.2-3,3.3c0,2.1,1.1,3.3,3,3.3c1.6,0,2.6-0.9,2.7-2.2h-1.2c-0.2,0.7-0.7,1-1.5,1 c-1,0-1.7-0.8-1.7-2.2c0-1.4,0.6-2.2,1.7-2.2c0.8,0,1.4,0.5,1.5,1.1H327.8z M328.9,246.4c0,0.9,0.6,1.5,1.8,1.8l1.1,0.3 c0.6,0.2,0.9,0.4,0.9,0.8c0,0.5-0.6,0.9-1.3,0.9c-0.8,0-1.2-0.3-1.4-0.8h-1.3c0.1,1.1,1.1,1.8,2.6,1.8c1.5,0,2.6-0.8,2.6-2 c0-0.9-0.6-1.5-1.8-1.7l-1.1-0.2c-0.7-0.2-1-0.4-1-0.8c0-0.5,0.5-0.8,1.2-0.8c0.7,0,1.2,0.3,1.3,0.8h1.2c-0.1-1.1-1.1-1.8-2.5-1.8 C330,244.5,328.9,245.3,328.9,246.4z M345.9,247.7v-1.1h-3.5v1.1h2.2v0.2c0,1.3-1,2.1-2.3,2.1c-1.6,0-2.6-1.2-2.6-3.2 c0-2,1-3.2,2.6-3.2c1.2,0,2,0.6,2.3,1.6h1.3c-0.3-1.7-1.7-2.8-3.6-2.8c-2.4,0-3.9,1.7-3.9,4.4c0,2.7,1.5,4.4,3.9,4.4 C344.5,251.2,345.9,249.8,345.9,247.7z M350.1,245.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C348.5,246.2,349.2,245.6,350.1,245.6z M351.7,249.3c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3 s1.1,3.3,2.9,3.3c1.5,0,2.5-0.7,2.8-1.8H351.7z M354.4,251h1.3v-8.9h-1.3V251z M364.6,251l3-8.5h-1.4l-2.3,6.8h-0.1l-2.3-6.8h-1.4 l3,8.5H364.6z M370.8,245.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C369.2,246.2,369.8,245.6,370.8,245.6z M372.3,249.3 c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3 c1.5,0,2.5-0.7,2.8-1.8H372.3z M375,251h1.3v-3.7c0-1,0.6-1.6,1.5-1.6c0.9,0,1.4,0.5,1.4,1.5v3.8h1.3v-4.1c0-1.5-0.8-2.4-2.2-2.4 c-1,0-1.6,0.4-1.9,1.1h-0.1v-1H375V251z M382.5,243v1.6h-1v1.1h1v3.6c0,1.2,0.6,1.7,2,1.7c0.2,0,0.5,0,0.7-0.1v-1 c-0.2,0-0.3,0-0.5,0c-0.6,0-0.9-0.3-0.9-1v-3.3h1.4v-1.1h-1.4V243H382.5z M391.9,244.6h-1.3v3.7c0,1-0.6,1.6-1.6,1.6 c-0.9,0-1.3-0.5-1.3-1.5v-3.8h-1.3v4.1c0,1.5,0.8,2.4,2.2,2.4c1,0,1.6-0.4,1.9-1.1h0.1v1h1.2V244.6z M393.6,251h1.3v-3.8 c0-0.9,0.7-1.5,1.6-1.5c0.2,0,0.6,0,0.7,0.1v-1.2c-0.1,0-0.4-0.1-0.6-0.1c-0.8,0-1.5,0.5-1.7,1.1h-0.1v-1h-1.2V251z M400.8,245.6 c0.9,0,1.5,0.7,1.6,1.7h-3.2C399.2,246.2,399.8,245.6,400.8,245.6z M402.3,249.3c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8 v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3c1.5,0,2.5-0.7,2.8-1.8H402.3z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    id: "result3"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: "304",
    y: "361",
    className: "blockIn",
    width: "239",
    height: "7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M215,308.5h352c1.9,0,3.5,1.6,3.5,3.5v66c0,1.9-1.6,3.5-3.5,3.5H215c-1.9,0-3.5-1.6-3.5-3.5v-66 C211.5,310.1,213.1,308.5,215,308.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "url",
    d: "M304.8,353h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9 c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V353z M311,346.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7 c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H311z M314.5,346.4v1.4h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4 c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4H314.5z M320.3,347.6 c-0.7,0-1.3,0.4-1.7,1h-0.1v-0.9h-0.8v7h0.8v-2.5h0.1c0.3,0.6,0.9,0.9,1.6,0.9c1.3,0,2.2-1.1,2.2-2.7 C322.5,348.7,321.6,347.6,320.3,347.6z M320.1,352.3c-0.9,0-1.5-0.8-1.5-2c0-1.2,0.6-2,1.6-2c1,0,1.5,0.7,1.5,2 C321.6,351.6,321,352.3,320.1,352.3z M323.6,349.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8 c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2 c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C324.4,347.6,323.6,348.3,323.6,349.2z M329.5,353c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,352.8,329.2,353,329.5,353z M329.5,349.3c0.4,0,0.6-0.3,0.6-0.6c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6 C328.9,349,329.2,349.3,329.5,349.3z M331.6,354.5l2.6-8.9h-0.7l-2.6,8.9H331.6z M334.9,354.5l2.6-8.9h-0.7l-2.6,8.9H334.9z M338,349.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C338.9,347.6,338,348.3,338,349.2z M343.3,353h0.8v-3.1c0-0.9,0.5-1.5,1.5-1.5 c0.8,0,1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.4,0.3-1.6,0.9h-0.1v-2.9h-0.8V353z M351.3,353.1 c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7C348.9,352.1,349.8,353.1,351.3,353.1z M351.3,352.3 c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2s1.6,0.7,1.6,2C352.8,351.6,352.3,352.3,351.3,352.3z M357,348.4c0.8,0,1.4,0.6,1.4,1.5 h-2.9C355.6,349,356.2,348.4,357,348.4z M358.4,351.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3 c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H358.4z M360.4,349.2 c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9 c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8 c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4C361.3,347.6,360.4,348.3,360.4,349.2z M366.4,353c0.4,0,0.6-0.3,0.6-0.6 c0-0.4-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6C365.7,352.8,366,353,366.4,353z M372.7,349.3c-0.1-0.9-0.9-1.7-2.2-1.7 c-1.5,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.3,0,2.1-0.7,2.2-1.7h-0.8c-0.2,0.6-0.6,0.9-1.4,0.9c-0.9,0-1.5-0.8-1.5-2 c0-1.2,0.6-1.9,1.5-1.9c0.8,0,1.2,0.4,1.4,0.9H372.7z M376,353.1c1.5,0,2.4-1,2.4-2.7c0-1.7-0.9-2.7-2.4-2.7c-1.5,0-2.4,1-2.4,2.7 C373.6,352.1,374.5,353.1,376,353.1z M376,352.3c-1,0-1.6-0.7-1.6-2c0-1.2,0.6-2,1.6-2c1,0,1.6,0.7,1.6,2 C377.6,351.6,377,352.3,376,352.3z M379.7,353h0.8v-3.3c0-0.7,0.5-1.3,1.2-1.3c0.7,0,1.1,0.4,1.1,1v3.6h0.8v-3.4 c0-0.7,0.5-1.2,1.2-1.2c0.7,0,1.1,0.4,1.1,1.2v3.4h0.8v-3.6c0-1.1-0.6-1.7-1.7-1.7c-0.7,0-1.3,0.4-1.6,0.9h-0.1 c-0.2-0.5-0.7-0.9-1.5-0.9c-0.7,0-1.2,0.3-1.5,0.9h-0.1v-0.8h-0.8V353z M388.2,354.5l2.6-8.9h-0.7l-2.6,8.9H388.2z M393.1,352.4 c-0.6,0-1.1-0.3-1.1-0.8c0-0.5,0.4-0.8,1.2-0.9l1.4-0.1v0.5C394.6,351.8,394,352.4,393.1,352.4z M393,353.1c0.7,0,1.3-0.3,1.6-0.9 h0.1v0.8h0.8v-3.6c0-1.1-0.7-1.8-2-1.8c-1.1,0-2,0.6-2.1,1.4h0.8c0.1-0.4,0.6-0.7,1.2-0.7c0.8,0,1.2,0.4,1.2,1v0.5l-1.5,0.1 c-1.2,0.1-1.9,0.6-1.9,1.6C391.2,352.5,391.9,353.1,393,353.1z M398.9,353.1c0.7,0,1.4-0.3,1.7-0.9h0.1v0.8h0.8v-7.4h-0.8v2.9 h-0.1c-0.3-0.6-0.9-0.9-1.6-0.9c-1.3,0-2.2,1.1-2.2,2.7C396.6,352,397.5,353.1,398.9,353.1z M399,348.4c1,0,1.5,0.8,1.5,2 c0,1.2-0.6,2-1.5,2c-1,0-1.5-0.7-1.5-2C397.5,349.1,398.1,348.4,399,348.4z M403,353h0.8v-5.3H403V353z M403.4,346.7 c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6c-0.3,0-0.6,0.3-0.6,0.6C402.8,346.4,403.1,346.7,403.4,346.7z M407.3,353.1 c0.7,0,1.4-0.3,1.7-0.9h0.1v0.8h0.8v-7.4H409v2.9h-0.1c-0.3-0.6-0.9-0.9-1.7-0.9c-1.3,0-2.2,1.1-2.2,2.7 C405,352,405.9,353.1,407.3,353.1z M407.5,348.4c1,0,1.5,0.8,1.5,2c0,1.2-0.6,2-1.5,2c-1,0-1.5-0.7-1.5-2 C405.9,349.1,406.5,348.4,407.5,348.4z M413,352.4c-0.6,0-1.1-0.3-1.1-0.8c0-0.5,0.4-0.8,1.2-0.9l1.4-0.1v0.5 C414.5,351.8,413.8,352.4,413,352.4z M412.8,353.1c0.7,0,1.3-0.3,1.6-0.9h0.1v0.8h0.8v-3.6c0-1.1-0.7-1.8-2-1.8 c-1.1,0-2,0.6-2.1,1.4h0.9c0.1-0.4,0.6-0.7,1.2-0.7c0.8,0,1.2,0.4,1.2,1v0.5L413,350c-1.2,0.1-1.9,0.6-1.9,1.6 C411,352.5,411.8,353.1,412.8,353.1z M416.6,349.2c0,0.8,0.5,1.2,1.4,1.4l0.9,0.2c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8 c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2 c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C417.5,347.6,416.6,348.3,416.6,349.2z M425.1,350.6v-0.8h-3.2v0.8H425.1z M426.4,349.2c0,0.8,0.4,1.2,1.4,1.4l0.9,0.2 c0.6,0.1,0.8,0.4,0.8,0.7c0,0.5-0.5,0.8-1.2,0.8c-0.7,0-1.1-0.3-1.2-0.7h-0.9c0.1,0.9,0.9,1.4,2.1,1.4c1.2,0,2.1-0.6,2.1-1.6 c0-0.8-0.5-1.2-1.5-1.4l-0.8-0.2c-0.6-0.2-0.9-0.4-0.9-0.7c0-0.5,0.5-0.8,1.1-0.8c0.6,0,1,0.3,1.2,0.7h0.8c-0.1-0.9-0.9-1.4-2-1.4 C427.2,347.6,426.4,348.3,426.4,349.2z M434.2,347.6c-0.7,0-1.3,0.4-1.7,1h-0.1v-0.9h-0.8v7h0.8v-2.5h0.1c0.3,0.6,0.9,0.9,1.6,0.9 c1.3,0,2.2-1.1,2.2-2.7C436.4,348.7,435.6,347.6,434.2,347.6z M434,352.3c-0.9,0-1.5-0.8-1.5-2c0-1.2,0.6-2,1.6-2 c1,0,1.5,0.7,1.5,2C435.6,351.6,435,352.3,434,352.3z M439.7,348.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C438.3,349,438.9,348.4,439.7,348.4 z M441.1,351.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7 c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H441.1z M445.4,348.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C443.9,349,444.5,348.4,445.4,348.4z M446.7,351.6c-0.2,0.5-0.7,0.7-1.4,0.7c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7 c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5H446.7z M450.8,353.1c0.7,0,1.4-0.3,1.7-0.9h0.1v0.8h0.8v-7.4h-0.8v2.9h-0.1 c-0.3-0.6-0.9-0.9-1.6-0.9c-1.3,0-2.2,1.1-2.2,2.7C448.6,352,449.5,353.1,450.8,353.1z M451,348.4c1,0,1.5,0.8,1.5,2 c0,1.2-0.6,2-1.5,2c-1,0-1.5-0.7-1.5-2C449.5,349.1,450.1,348.4,451,348.4z M458.1,350.6v-0.8h-3.2v0.8H458.1z M459.7,346.4v1.4 h-0.9v0.7h0.9v3.2c0,1,0.4,1.4,1.5,1.4c0.2,0,0.3,0,0.5,0v-0.7c-0.2,0-0.2,0-0.4,0c-0.5,0-0.8-0.3-0.8-0.9v-3h1.2v-0.7h-1.2v-1.4 H459.7z M462.9,353h0.8v-3.3c0-0.7,0.6-1.3,1.4-1.3c0.2,0,0.5,0,0.5,0v-0.8c-0.1,0-0.3,0-0.4,0c-0.7,0-1.3,0.4-1.5,0.9h-0.1v-0.8 h-0.8V353z M468.2,352.4c-0.6,0-1.1-0.3-1.1-0.8c0-0.5,0.4-0.8,1.2-0.9l1.4-0.1v0.5C469.7,351.8,469.1,352.4,468.2,352.4z M468,353.1c0.7,0,1.3-0.3,1.6-0.9h0.1v0.8h0.8v-3.6c0-1.1-0.7-1.8-2-1.8c-1.1,0-2,0.6-2.1,1.4h0.8c0.1-0.4,0.6-0.7,1.2-0.7 c0.8,0,1.2,0.4,1.2,1v0.5l-1.5,0.1c-1.2,0.1-1.9,0.6-1.9,1.6C466.3,352.5,467,353.1,468,353.1z M472,353h0.8v-5.3H472V353z M472.4,346.7c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6s-0.6,0.3-0.6,0.6C471.9,346.4,472.1,346.7,472.4,346.7z M474.4,353 h0.8v-3.1c0-0.9,0.5-1.5,1.4-1.5s1.2,0.5,1.2,1.4v3.2h0.8v-3.4c0-1.2-0.7-1.9-1.8-1.9c-0.8,0-1.3,0.3-1.6,0.9h-0.1v-0.8h-0.8V353z M482.2,348.4c0.8,0,1.4,0.6,1.4,1.5h-2.9C480.8,349,481.4,348.4,482.2,348.4z M483.6,351.6c-0.2,0.5-0.7,0.7-1.4,0.7 c-0.9,0-1.5-0.7-1.5-1.7v0h3.8v-0.3c0-1.6-0.9-2.6-2.3-2.6c-1.4,0-2.4,1.1-2.4,2.7c0,1.7,0.9,2.7,2.4,2.7c1.2,0,2-0.6,2.2-1.5 H483.6z M485.7,353h0.8v-3.3c0-0.7,0.6-1.3,1.4-1.3c0.2,0,0.5,0,0.5,0v-0.8c-0.1,0-0.3,0-0.4,0c-0.7,0-1.3,0.4-1.5,0.9h-0.1v-0.8 h-0.8V353z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    className: "shoe"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M266.1,326.3c-0.7,0.5-1.4,1.4-1.9,2.4c-0.3,0.5-0.5,1-0.6,1.1c-0.3,0.2-0.5,0.7-0.5,1.1 c0,0.3-0.1,0.5-0.4,0.7c-0.7,0.6-1.4,2-1.8,3.5c-0.1,0.4-0.2,0.5-0.5,0.6c-0.6,0.3-0.8,0.7-0.8,1.5c0,0.7,0,0.7-0.4,1 c-0.2,0.2-0.5,0.3-0.5,0.3c-0.2,0-0.8,0.5-1,0.9c-0.2,0.5-1.1,1.2-1.6,1.2c-0.4,0.1-1,0.4-1.1,0.7c-0.1,0.3-1.7,0.9-2.4,0.9 c-0.4,0-0.9,0.2-1.3,0.5c-0.2,0.2-1.6,0.7-2,0.7c-0.4,0-0.7,0.1-1.1,0.5c-0.4,0.4-1.7,0.8-2.4,0.9c-0.5,0-0.6,0.1-1.1,0.6 c-0.3,0.3-0.6,0.7-0.6,0.9c-0.1,0.2-0.1,0.4-0.1,0.5c0,0-0.5,0.1-1.1,0.2c-1.6,0.3-4.2,0.6-7,0.8c-2.8,0.2-3.2,0.3-3.8,0.7 c-0.6,0.5-1.3,1.9-1.3,2.8c0,0.1-0.1,0.3-0.1,0.3c-0.3,0.1-0.5,0.6-0.6,1.5c-0.2,1.6,0,2.4,1.2,3.5c1.9,1.8,6.3,3,12.2,3.6 c0.7,0.1,1.5,0.2,1.8,0.3c0.3,0.1,0.8,0.2,1.1,0.2c1.6,0,3,0.1,3.6,0.1c0.4,0.1,0.8,0,1.1,0c0.4-0.1,0.5-0.1,0.8,0 c0.5,0.2,3.4,0.3,4.1,0.1c0.4-0.1,0.6-0.1,1.1,0c0.3,0.1,0.7,0.1,0.8,0c0.1,0,0.8-0.1,1.5-0.1c0.7,0,1.4,0,1.6,0 c0.2,0,0.6,0,0.9,0c0.3,0,3.1,0,6.2,0c3.1,0,5.8,0,6,0c0.6,0,4.2-0.1,4.3-0.2c0.1,0,0.6-0.1,1.2-0.1c2.3-0.1,2.9-0.1,3.2-0.3 c0.2-0.1,0.5-0.2,0.7-0.2c0.6,0,1.5-0.6,1.6-1.2c0-0.2,0.1-1.4,0.1-2.6c0-2.1,0-2.3-0.1-2.6c-0.2-0.3-0.2-0.4-0.1-0.8 c0.2-0.7,0.2-4.6,0.1-6.4c-0.1-1.8-0.4-3.9-0.8-5.9c-0.3-1.8-1.3-5.5-1.5-5.9c-0.2-0.5-0.5-0.6-1.3-0.4 c-1.5,0.3-4.3-0.2-6.9-1.4l-0.9-0.4l-0.2-0.8c-0.3-1.2-1.2-2.4-2.8-3.6c-1.3-1-3.3-2.2-3.7-2.2 C266.6,326,266.4,326.1,266.1,326.3z M267.7,326.8c2.8,1.6,4.9,3.5,5.2,4.9c0.1,0.3,0,0.3-0.6-0.3c-0.4-0.3-1.1-0.8-1.5-1 c-0.7-0.4-0.9-0.4-1.7-0.4c-0.8,0-1,0-1.5,0.3c-0.7,0.4-1.6,1.2-2.3,2.1c-0.2,0.4-0.8,1.1-1.3,1.5c-0.8,0.8-1.3,1.7-1.3,2.1 c0,0.2,0,0.2-0.6-0.1c-0.3-0.2-0.6-0.3-0.7-0.3c-0.2,0-0.2-0.3,0-1.1c0.4-1.4,1.1-2.5,1.7-2.9c0.3-0.2,0.3-0.3,0.3-0.4 c-0.1-0.4,0.1-1,0.4-1.3c0.2-0.2,0.4-0.6,0.6-1c0.4-0.9,1.2-2,1.8-2.4c0.3-0.2,0.5-0.3,0.6-0.3 C266.8,326.3,267.3,326.5,267.7,326.8z M268.8,331.7c0,0.3-0.2,0.4-0.4,0.2c-0.1-0.1-0.1-0.2,0-0.3 C268.4,331.4,268.7,331.5,268.8,331.7z M267.4,333.1c0.4,0.2,3.4,2.3,5.1,3.6c2.2,1.7,4.2,3.5,6.4,5.6c2.9,2.9,3.8,3.6,5.1,3.7 l0.6,0.1l0.1,2c0.1,3-0.1,5.2-0.6,5.6c-0.6,0.5-2.3,0.7-7.3,0.9c-1.7,0.1-3.7,0.1-4.4,0.2l-1.2,0.1l0.2-0.6 c0.1-0.4,0.3-1.2,0.4-1.8c0.7-4.6-1.2-9.2-5-12.5c-1.9-1.7-3.4-3-3.5-3.2c-0.1-0.3,0.3-1.2,0.8-1.8 C265.1,333.2,266.3,332.6,267.4,333.1z M261.8,336.1c0.5,0.2,0.8,0.4,1.5,1.1c0.5,0.5,1.2,1.2,1.6,1.5l0.7,0.6v0.6 c0,0.8-0.1,1.3-0.5,1.7c-0.3,0.3-1.4,0.7-8.8,3.2c-4.6,1.6-8.8,3-9.2,3.1c-0.4,0.1-1.1,0.2-1.5,0.2c-0.7,0-0.7,0-0.9-0.2 c-0.1-0.2-0.2-0.5-0.2-0.9c0-0.8,0.2-1.1,0.3-0.5c0.2,0.6,0.6,0.9,1,0.9c0.6,0,0.7-0.4,0.7-1.4l0-0.8l0.8-0.3 c0.5-0.2,0.8-0.3,0.9-0.3c0,0,0.1,0.3,0.1,0.5c0.1,0.6,0.4,1.2,0.7,1.3c0.3,0.1,0.8-0.1,0.9-0.5c0.1-0.3,0.1-1.1-0.1-1.8 c-0.1-0.2,0-0.3,0.8-0.6l0.9-0.3l0.1,0.4c0.2,0.6,0.5,1.2,0.7,1.3c0.4,0.2,0.8,0.1,1-0.1c0.2-0.3,0.2-1.1,0-1.7 c-0.1-0.2-0.1-0.5-0.1-0.5c0.1-0.1,1.7-0.6,1.7-0.6c0,0,0.1,0.3,0.3,0.7c0.3,0.8,0.7,1.2,1.1,1.2c0.8,0,1-0.9,0.5-2.4l-0.2-0.6 l0.5-0.5c0.3-0.2,0.5-0.4,0.6-0.3c0.1,0.2,0.8,1.4,1,1.6c0.1,0.1,0.4,0.3,0.5,0.4c0.3,0.1,0.3,0.1,0.5,0c0.5-0.3,0.5-1.1,0-2.2 c-0.2-0.4-0.4-0.8-0.5-0.9c-0.2-0.3-0.2-0.3,0.1-0.6c0.2-0.2,0.4-0.3,0.5-0.3c0.1,0,0.4,0.4,0.8,0.8c1,1.4,2.1,2,2.7,1.7 c0.3-0.2,0.3-0.4,0-1c-0.4-0.8-2.2-3.2-2.6-3.6c-0.1-0.1-0.1-0.1,0-0.2C261.1,335.9,261.2,335.9,261.8,336.1z M244.2,347.4 c0.1,0.5,0.3,0.9,0.6,1c0.3,0.1,1.3,2.1,1.5,3c0.2,0.7,0,1-0.5,1.4c-0.7,0.4-1.4,0.2-2.5-0.9c-1.2-1.2-2.5-1.6-5.4-1.8 c-1.7-0.2-3.1-0.4-3.7-0.7c-0.4-0.2-0.9-0.7-0.9-0.8c0-0.1,0.7-0.2,2.6-0.3c2.6-0.2,6-0.6,7.3-0.9c0.4-0.1,0.8-0.2,0.8-0.2 C244.1,347.2,244.1,347.3,244.2,347.4z M231.3,352.3c0.5,0.5,2,1.3,3.2,1.7c1.8,0.6,3.7,1,6.5,1.3c4.8,0.6,7.7,0.8,11.9,0.8 c4,0,4.9,0,12.9-0.7c1-0.1,2.7-0.2,3.7-0.2c1.9-0.1,2.8-0.2,8.3-0.3c4.1-0.1,5.6-0.4,6.5-0.9c0.1-0.1,0.3-0.1,0.3-0.1 c0.1,0.1,0,4.8-0.1,5.1c-0.1,0.3-0.7,0.7-1.2,0.7c-0.2,0-0.6,0.1-0.8,0.2c-0.4,0.2-0.8,0.2-3,0.3c-0.5,0-1.5,0.1-2,0.1 c-0.6,0-2.6,0.1-4.5,0.1s-3.6,0-3.8,0c-0.2,0-1.1,0-1.9,0c-0.8,0-1.8,0-2,0c-0.8,0-1.7,0-2,0c-0.1,0-0.6,0-0.9,0.1 c-0.4,0-0.8,0-1-0.1c-0.3-0.1-0.4-0.1-0.7,0.1c-0.3,0.1-0.5,0.2-1.1,0.1c-0.4,0-0.8-0.1-0.8-0.1c-0.8,0.1-1.5,0.1-1.9,0 c-0.4-0.1-0.5-0.1-0.6,0c-0.2,0.2-3.5,0.2-4.2,0c-0.4-0.2-0.5-0.2-1.1,0c-0.5,0.1-0.7,0.1-1.2,0c-0.5-0.1-0.7-0.1-0.9-0.1 c-0.2,0.1-0.6,0.1-0.9,0c-0.3,0-0.9-0.1-1.2-0.1c-0.3,0-0.9-0.1-1.3-0.2c-0.4-0.1-1-0.2-1.3-0.2c-1,0-4.6-0.5-6.6-1 c-2.5-0.6-4.9-1.6-5.9-2.6c-0.7-0.7-0.9-1.1-1-1.9c-0.1-0.8,0.2-2.5,0.4-2.5C230.8,351.9,231,352.1,231.3,352.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M265.9,333.8c-0.3,0.3-0.1,0.7,0.4,0.7c0.3,0,0.4-0.4,0.2-0.7C266.3,333.6,266.1,333.6,265.9,333.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "st4",
    d: "M264.3,335.6c-0.1,0.1-0.1,0.6,0.1,0.7c0.4,0.2,0.7-0.1,0.6-0.6C264.9,335.6,264.4,335.5,264.3,335.6z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleBox",
    d: "M300,319.5h231c1.9,0,3.5,1.6,3.5,3.5v14c0,1.9-1.6,3.5-3.5,3.5H300c-1.9,0-3.5-1.6-3.5-3.5v-14 C296.5,321.1,298.1,319.5,300,319.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "titleCopy",
    d: "M310.5,334h1.4l-3.1-8.5h-1.4l-3.1,8.5h1.3l0.8-2.2h3.2L310.5,334z M308.1,327.1L308.1,327.1l1.3,3.6h-2.6 L308.1,327.1z M315.1,334.1c0.9,0,1.6-0.4,2-1.1h0.1v1h1.2v-8.9h-1.3v3.5h-0.1c-0.3-0.7-1.1-1.1-2-1.1c-1.6,0-2.6,1.3-2.6,3.3 C312.5,332.8,313.5,334.1,315.1,334.1z M315.5,328.6c1.1,0,1.7,0.8,1.7,2.2c0,1.3-0.7,2.2-1.7,2.2c-1.1,0-1.7-0.8-1.7-2.2 C313.8,329.5,314.4,328.6,315.5,328.6z M320.2,334h1.3v-6.4h-1.3V334z M320.9,326.5c0.5,0,0.8-0.3,0.8-0.8c0-0.4-0.3-0.8-0.8-0.8 c-0.5,0-0.8,0.3-0.8,0.8C320,326.2,320.4,326.5,320.9,326.5z M325.5,334.1c0.9,0,1.6-0.4,2-1.1h0.1v1h1.2v-8.9h-1.3v3.5h-0.1 c-0.3-0.7-1.1-1.1-2-1.1c-1.6,0-2.6,1.3-2.6,3.3C322.9,332.8,323.9,334.1,325.5,334.1z M325.9,328.6c1.1,0,1.7,0.8,1.7,2.2 c0,1.3-0.7,2.2-1.7,2.2c-1.1,0-1.7-0.8-1.7-2.2C324.2,329.5,324.8,328.6,325.9,328.6z M332.7,333c-0.7,0-1.2-0.3-1.2-0.9 c0-0.6,0.4-0.9,1.3-0.9l1.6-0.1v0.5C334.4,332.4,333.7,333,332.7,333z M332.4,334.1c0.8,0,1.5-0.4,1.9-1h0.1v0.9h1.2v-4.4 c0-1.3-0.9-2.1-2.5-2.1c-1.4,0-2.5,0.7-2.6,1.8h1.2c0.1-0.5,0.6-0.7,1.3-0.7c0.9,0,1.3,0.4,1.3,1.1v0.6l-1.7,0.1 c-1.5,0.1-2.4,0.8-2.4,1.9C330.3,333.4,331.2,334.1,332.4,334.1z M337.1,329.4c0,0.9,0.6,1.5,1.8,1.8l1.1,0.3 c0.6,0.2,0.9,0.4,0.9,0.8c0,0.5-0.6,0.9-1.3,0.9c-0.8,0-1.2-0.3-1.4-0.8H337c0.1,1.1,1.1,1.8,2.6,1.8c1.5,0,2.6-0.8,2.6-2 c0-0.9-0.6-1.5-1.8-1.7l-1.1-0.2c-0.7-0.2-1-0.4-1-0.8c0-0.5,0.5-0.8,1.2-0.8c0.7,0,1.2,0.3,1.3,0.8h1.2c-0.1-1.1-1.1-1.8-2.5-1.8 C338.2,327.5,337.1,328.3,337.1,329.4z M346.5,331.7c0.1,1.5,1.4,2.5,3.2,2.5c2,0,3.3-1,3.3-2.6c0-1.3-0.7-2-2.4-2.4l-0.9-0.2 c-1.1-0.3-1.5-0.6-1.5-1.2c0-0.8,0.7-1.3,1.7-1.3c1,0,1.7,0.5,1.8,1.3h1.3c-0.1-1.4-1.3-2.4-3-2.4c-1.8,0-3.1,1-3.1,2.5 c0,1.2,0.7,2,2.2,2.3l1.1,0.3c1.1,0.3,1.6,0.7,1.6,1.3c0,0.8-0.8,1.3-1.8,1.3c-1.1,0-1.9-0.5-2-1.3H346.5z M357.8,327.5 c-0.9,0-1.6,0.4-2,1.2h-0.1v-1.1h-1.2v8.5h1.3V333h0.1c0.3,0.7,1.1,1.1,2,1.1c1.6,0,2.6-1.3,2.6-3.3 C360.5,328.8,359.4,327.5,357.8,327.5z M357.5,333c-1.1,0-1.7-0.8-1.7-2.2c0-1.3,0.7-2.2,1.7-2.2c1.1,0,1.7,0.8,1.7,2.2 C359.2,332.2,358.5,333,357.5,333z M364.5,328.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C362.9,329.2,363.5,328.6,364.5,328.6z M366,332.3 c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3 c1.5,0,2.5-0.7,2.8-1.8H366z M371.3,328.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C369.8,329.2,370.4,328.6,371.3,328.6z M372.9,332.3 c-0.2,0.5-0.8,0.8-1.5,0.8c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3 c1.5,0,2.5-0.7,2.8-1.8H372.9z M377.9,334.1c0.9,0,1.6-0.4,2-1.1h0.1v1h1.2v-8.9H380v3.5h-0.1c-0.3-0.7-1.1-1.1-2-1.1 c-1.6,0-2.6,1.3-2.6,3.3C375.3,332.8,376.3,334.1,377.9,334.1z M378.3,328.6c1.1,0,1.7,0.8,1.7,2.2c0,1.3-0.7,2.2-1.7,2.2 c-1.1,0-1.7-0.8-1.7-2.2C376.6,329.5,377.2,328.6,378.3,328.6z M389.8,334v-7.3h2.7v-1.2h-6.6v1.2h2.7v7.3H389.8z M393,334h1.3 v-3.8c0-0.9,0.7-1.5,1.6-1.5c0.2,0,0.6,0,0.7,0.1v-1.2c-0.1,0-0.4-0.1-0.6-0.1c-0.8,0-1.5,0.5-1.7,1.1h-0.1v-1H393V334z M399.7,333c-0.7,0-1.2-0.3-1.2-0.9c0-0.6,0.4-0.9,1.3-0.9l1.6-0.1v0.5C401.3,332.4,400.6,333,399.7,333z M399.4,334.1 c0.8,0,1.5-0.4,1.9-1h0.1v0.9h1.2v-4.4c0-1.3-0.9-2.1-2.5-2.1c-1.4,0-2.5,0.7-2.6,1.8h1.2c0.1-0.5,0.6-0.7,1.3-0.7 c0.9,0,1.3,0.4,1.3,1.1v0.6l-1.7,0.1c-1.5,0.1-2.4,0.8-2.4,1.9C397.2,333.4,398.1,334.1,399.4,334.1z M404.3,334h1.3v-6.4h-1.3 V334z M404.9,326.5c0.5,0,0.8-0.3,0.8-0.8c0-0.4-0.3-0.8-0.8-0.8s-0.8,0.3-0.8,0.8C404.1,326.2,404.4,326.5,404.9,326.5z M407.3,334h1.3v-3.7c0-1,0.6-1.6,1.5-1.6s1.4,0.5,1.4,1.5v3.8h1.3v-4.1c0-1.5-0.8-2.4-2.2-2.4c-1,0-1.6,0.4-1.9,1.1h-0.1v-1h-1.2 V334z M417,328.6c0.9,0,1.5,0.7,1.6,1.7h-3.2C415.4,329.2,416,328.6,417,328.6z M418.5,332.3c-0.2,0.5-0.8,0.8-1.5,0.8 c-1,0-1.7-0.7-1.7-1.8v-0.1h4.5v-0.4c0-2-1.1-3.2-2.8-3.2c-1.8,0-2.9,1.3-2.9,3.3s1.1,3.3,2.9,3.3c1.5,0,2.5-0.7,2.8-1.8H418.5z M421.2,334h1.3v-3.8c0-0.9,0.7-1.5,1.6-1.5c0.2,0,0.6,0,0.7,0.1v-1.2c-0.1,0-0.4-0.1-0.6-0.1c-0.8,0-1.5,0.5-1.7,1.1h-0.1v-1 h-1.2V334z"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    id: "filter"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M34,237.5h151c1.9,0,3.5,1.6,3.5,3.5v163c0,1.9-1.6,3.5-3.5,3.5H34c-1.9,0-3.5-1.6-3.5-3.5V241 C30.5,239.1,32.1,237.5,34,237.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "header",
    d: "M50.3,269v-3.8h4v-1.7h-4v-2.6h4.4v-1.8h-6.5v9.9H50.3z M58.5,269v-9.9h-2.1v9.9H58.5z M67.2,267.2h-4.4v-8.1 h-2.1v9.9h6.5V267.2z M72.1,269v-8.1h3v-1.8h-8v1.8h3v8.1H72.1z M83.3,267.2h-4.5v-2.4H83v-1.6h-4.2v-2.3h4.5v-1.8h-6.5v9.9h6.5 V267.2z M87.4,260.8h1.8c1,0,1.7,0.6,1.7,1.5c0,1-0.6,1.5-1.6,1.5h-1.8V260.8z M87.4,265.4h1.7l1.8,3.6h2.3l-2.1-3.9 c1.1-0.5,1.8-1.5,1.8-2.8c0-2-1.3-3.2-3.5-3.2h-4.1v9.9h2.1V265.4z M102.8,269c2.1,0,3.4-1.1,3.4-2.8c0-1.3-1-2.3-2.3-2.4v-0.1 c1-0.1,1.8-1.1,1.8-2.1c0-1.5-1.1-2.5-3.1-2.5h-4.3v9.9H102.8z M100.4,260.7h1.7c1,0,1.6,0.5,1.6,1.3c0,0.8-0.6,1.3-1.7,1.3h-1.6 V260.7z M100.4,267.4v-2.8h1.8c1.2,0,1.9,0.5,1.9,1.4c0,0.9-0.6,1.4-1.8,1.4H100.4z M112.4,269v-3.6l3.4-6.2h-2.2l-2.2,4.1h-0.1 l-2.2-4.1h-2.2l3.4,6.2v3.6H112.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "filterCopy",
    d: "M82,298v-9.9h-1.4l-3.4,8.2h-0.1l-3.4-8.2h-1.4v9.9h1.1v-7.5h0.1l3.1,7.5h1l3.1-7.5h0.1v7.5H82z M87.1,291.5 c1.2,0,1.9,0.9,2,2.2h-4.1C85.1,292.4,86,291.5,87.1,291.5z M89.1,296.1c-0.3,0.6-1,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5 c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H89.1z M92.1,298h1.2v-4.4 c0-1.3,0.8-2.1,1.9-2.1c1.2,0,1.7,0.6,1.7,2v4.5h1.2v-4.8c0-1.8-0.9-2.7-2.6-2.7c-1.1,0-1.8,0.5-2.2,1.3h-0.1v-1.2h-1.1V298z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "filterCopy",
    d: "M102.7,328h1.3l-3.6-9.9h-1.2l-3.6,9.9h1.3l1-2.8h3.9L102.7,328z M99.7,319.7h0.1l1.5,4.4h-3.2L99.7,319.7z M105.5,318.7v1.9h-1.2v1h1.2v4.5c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6 v-1h-1.6v-1.9H105.5z M110,328h1.2v-4.4c0-1.2,0.7-2.1,2-2.1c1.1,0,1.7,0.6,1.7,2v4.5h1.2v-4.8c0-1.7-1-2.7-2.5-2.7 c-1.1,0-1.9,0.5-2.3,1.3h-0.1v-4.1H110V328z M118.2,328h1.2v-10.3h-1.2V328z M124.4,321.5c1.2,0,1.9,0.9,2,2.2h-4.1 C122.4,322.4,123.3,321.5,124.4,321.5z M126.4,326.1c-0.3,0.6-0.9,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5 c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H126.4z M129.8,318.7v1.9h-1.2v1h1.2v4.5 c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6v-1H131v-1.9H129.8z M134.3,328h1.2 v-7.4h-1.2V328z M134.9,319.1c0.5,0,0.8-0.4,0.8-0.8c0-0.5-0.4-0.8-0.8-0.8s-0.8,0.4-0.8,0.8C134.1,318.8,134.5,319.1,134.9,319.1z M143.7,322.9c-0.2-1.3-1.3-2.4-3.1-2.4c-2.1,0-3.4,1.5-3.4,3.8c0,2.3,1.3,3.8,3.4,3.8c1.8,0,2.9-1,3.1-2.4h-1.2 c-0.2,0.8-0.9,1.3-1.9,1.3c-1.3,0-2.2-1.1-2.2-2.8c0-1.7,0.8-2.7,2.2-2.7c1.1,0,1.7,0.6,1.9,1.3H143.7z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "filterCopy",
    d: "M77.7,352.2L77.7,352.2l2.4,7.8h1.2l2.7-9.9h-1.3l-2,8h-0.1l-2.2-8h-1.2l-2.2,8h-0.1l-2-8h-1.3l2.7,9.9h1.2 L77.7,352.2z M87.9,360.1c2.1,0,3.4-1.4,3.4-3.8c0-2.4-1.3-3.8-3.4-3.8c-2.1,0-3.4,1.4-3.4,3.8C84.5,358.7,85.8,360.1,87.9,360.1z M87.9,359.1c-1.4,0-2.2-1-2.2-2.8c0-1.8,0.8-2.8,2.2-2.8c1.4,0,2.2,1,2.2,2.8C90,358.1,89.3,359.1,87.9,359.1z M93,360h1.2v-4.6 c0-1,0.7-1.9,1.7-1.9c0.9,0,1.5,0.6,1.5,1.4v5h1.2v-4.7c0-0.9,0.7-1.7,1.7-1.7c1,0,1.6,0.5,1.6,1.6v4.8h1.2v-5.1 c0-1.5-0.8-2.4-2.3-2.4c-1,0-1.9,0.5-2.3,1.3h-0.1c-0.3-0.8-1-1.3-2-1.3c-1,0-1.7,0.5-2.1,1.3h-0.1v-1.2H93V360z M107.9,353.5 c1.2,0,1.9,0.9,2,2.2h-4.1C105.9,354.4,106.8,353.5,107.9,353.5z M109.9,358.1c-0.3,0.6-1,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3 v-0.5c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H109.9z M112.9,360h1.2v-4.4 c0-1.3,0.8-2.1,1.9-2.1s1.7,0.6,1.7,2v4.5h1.2v-4.8c0-1.8-0.9-2.7-2.6-2.7c-1.1,0-1.8,0.5-2.2,1.3H114v-1.2h-1.1V360z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "filterCopy",
    d: "M102.7,390h1.3l-3.6-9.9h-1.2l-3.6,9.9h1.3l1-2.8h3.9L102.7,390z M99.7,381.7h0.1l1.5,4.4h-3.2L99.7,381.7z M105.5,380.7v1.9h-1.2v1h1.2v4.5c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6 v-1h-1.6v-1.9H105.5z M110,390h1.2v-4.4c0-1.2,0.7-2.1,2-2.1c1.1,0,1.7,0.6,1.7,2v4.5h1.2v-4.8c0-1.7-1-2.7-2.5-2.7 c-1.1,0-1.9,0.5-2.3,1.3h-0.1v-4.1H110V390z M118.2,390h1.2v-10.3h-1.2V390z M124.4,383.5c1.2,0,1.9,0.9,2,2.2h-4.1 C122.4,384.4,123.3,383.5,124.4,383.5z M126.4,388.1c-0.3,0.6-0.9,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5 c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H126.4z M129.8,380.7v1.9h-1.2v1h1.2v4.5 c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6v-1H131v-1.9H129.8z M134.3,390h1.2 v-7.4h-1.2V390z M134.9,381.1c0.5,0,0.8-0.4,0.8-0.8c0-0.5-0.4-0.8-0.8-0.8s-0.8,0.4-0.8,0.8C134.1,380.8,134.5,381.1,134.9,381.1z M143.7,384.9c-0.2-1.3-1.3-2.4-3.1-2.4c-2.1,0-3.4,1.5-3.4,3.8c0,2.3,1.3,3.8,3.4,3.8c1.8,0,2.9-1,3.1-2.4h-1.2 c-0.2,0.8-0.9,1.3-1.9,1.3c-1.3,0-2.2-1.1-2.2-2.8c0-1.7,0.8-2.7,2.2-2.7c1.1,0,1.7,0.6,1.9,1.3H143.7z"
  }), /*#__PURE__*/_react.default.createElement("rect", {
    x: "48",
    y: "286",
    className: "checkbox",
    width: "14",
    height: "14"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "check",
    d: "M53.3,294.7l5.1-5.1c0.3-0.3,0.8-0.3,1.1,0c0.3,0.3,0.3,0.8,0,1.1l-5.7,5.7c-0.3,0.3-0.8,0.3-1.1,0l-2.3-2.3 c-0.3-0.3-0.3-0.8,0-1.1c0.3-0.3,0.8-0.3,1.1,0L53.3,294.7z"
  }), /*#__PURE__*/_react.default.createElement("rect", {
    x: "71",
    y: "316",
    className: "checkbox",
    width: "14",
    height: "14"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "check",
    d: "M76.3,324.7l5.1-5.1c0.3-0.3,0.8-0.3,1.1,0c0.3,0.3,0.3,0.8,0,1.1l-5.7,5.7c-0.3,0.3-0.8,0.3-1.1,0l-2.3-2.3 c-0.3-0.3-0.3-0.8,0-1.1c0.3-0.3,0.8-0.3,1.1,0L76.3,324.7z"
  }), /*#__PURE__*/_react.default.createElement("rect", {
    x: "48",
    y: "347",
    className: "checkbox",
    width: "14",
    height: "14"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "check",
    d: "M53.3,355.7l5.1-5.1c0.3-0.3,0.8-0.3,1.1,0c0.3,0.3,0.3,0.8,0,1.1l-5.7,5.7c-0.3,0.3-0.8,0.3-1.1,0l-2.3-2.3 c-0.3-0.3-0.3-0.8,0-1.1c0.3-0.3,0.8-0.3,1.1,0L53.3,355.7z"
  }), /*#__PURE__*/_react.default.createElement("rect", {
    x: "71",
    y: "377",
    className: "checkbox",
    width: "14",
    height: "14"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "check",
    d: "M76.3,385.7l5.1-5.1c0.3-0.3,0.8-0.3,1.1,0c0.3,0.3,0.3,0.8,0,1.1l-5.7,5.7c-0.3,0.3-0.8,0.3-1.1,0l-2.3-2.3 c-0.3-0.3-0.3-0.8,0-1.1c0.3-0.3,0.8-0.3,1.1,0L76.3,385.7z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    id: "sort"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M20,117.5h151c1.9,0,3.5,1.6,3.5,3.5v83c0,1.9-1.6,3.5-3.5,3.5H20c-1.9,0-3.5-1.6-3.5-3.5v-83 C16.5,119.1,18.1,117.5,20,117.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "header",
    d: "M33.8,146.3c0.1,1.8,1.6,3,4,3c2.5,0,4-1.2,4-3.2c0-1.5-0.9-2.4-2.8-2.8l-1.2-0.3c-1.2-0.2-1.6-0.6-1.6-1.2 c0-0.8,0.7-1.2,1.7-1.2c1,0,1.7,0.5,1.8,1.3h1.9c-0.1-1.8-1.6-3-3.8-3c-2.3,0-3.8,1.2-3.8,3.1c0,1.5,0.9,2.4,2.7,2.8l1.3,0.3 c1.2,0.3,1.7,0.6,1.7,1.3c0,0.7-0.8,1.3-1.8,1.3c-1.2,0-2-0.5-2.1-1.3H33.8z M47.8,138.9c-2.9,0-4.8,2-4.8,5.2 c0,3.2,1.8,5.2,4.8,5.2c2.9,0,4.7-2,4.7-5.2C52.6,140.9,50.7,138.9,47.8,138.9z M47.8,140.7c1.6,0,2.6,1.3,2.6,3.4 c0,2.1-1,3.4-2.6,3.4c-1.6,0-2.6-1.3-2.6-3.4C45.2,142,46.2,140.7,47.8,140.7z M56.4,140.8h1.8c1,0,1.7,0.6,1.7,1.5 c0,0.9-0.6,1.5-1.6,1.5h-1.8V140.8z M56.4,145.4h1.7L60,149h2.3l-2.1-3.9c1.1-0.5,1.8-1.5,1.8-2.8c0-2-1.3-3.2-3.5-3.2h-4.1v9.9 h2.1V145.4z M68.4,149v-8.1h3v-1.8h-8v1.8h3v8.1H68.4z M81,149c2.1,0,3.4-1.1,3.4-2.8c0-1.3-1-2.3-2.3-2.4v-0.1 c1-0.1,1.8-1.1,1.8-2.1c0-1.5-1.1-2.5-3.1-2.5h-4.3v9.9H81z M78.6,140.7h1.7c1,0,1.6,0.5,1.6,1.3c0,0.8-0.6,1.3-1.7,1.3h-1.6V140.7 z M78.6,147.4v-2.8h1.8c1.2,0,1.9,0.5,1.9,1.4c0,0.9-0.6,1.4-1.8,1.4H78.6z M90.6,149v-3.6l3.4-6.2h-2.2l-2.2,4.1h-0.1l-2.2-4.1 h-2.2l3.4,6.2v3.6H90.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "selectCopy",
    d: "M57,168h63v10H57V168z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "selectBox",
    d: "M38,160.5h115c1.9,0,3.5,1.6,3.5,3.5v19c0,1.9-1.6,3.5-3.5,3.5H38c-1.9,0-3.5-1.6-3.5-3.5v-19 C34.5,162.1,36.1,160.5,38,160.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "selectCopy",
    d: "M45.5,178v-7.6h0.1l5.4,7.6h1.2v-9.9h-1.2v7.7h-0.1l-5.4-7.7h-1.2v9.9H45.5z M57.3,171.5c1.2,0,1.9,0.9,2,2.2 h-4.1C55.3,172.4,56.1,171.5,57.3,171.5z M59.2,176.1c-0.3,0.6-1,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5 c0-2.3-1.2-3.7-3.2-3.7c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H59.2z M71.5,170.6h-1.2l-1.4,5.9h-0.1 l-1.6-5.9H66l-1.6,5.9h-0.1l-1.4-5.9h-1.2l2.1,7.4h1.2l1.6-5.7h0.1l1.6,5.7h1.2L71.5,170.6z M75.6,171.5c1.2,0,1.9,0.9,2,2.2h-4.1 C73.6,172.4,74.4,171.5,75.6,171.5z M77.5,176.1c-0.3,0.6-1,1-1.9,1c-1.3,0-2.1-0.9-2.1-2.4v-0.1h5.3v-0.5c0-2.3-1.2-3.7-3.2-3.7 c-2,0-3.3,1.5-3.3,3.8c0,2.3,1.3,3.8,3.3,3.8c1.6,0,2.7-0.8,3.1-2H77.5z M80.3,172.6c0,1.1,0.6,1.7,2,2l1.3,0.3 c0.8,0.2,1.2,0.5,1.2,1c0,0.7-0.7,1.1-1.7,1.1c-0.9,0-1.5-0.4-1.7-1h-1.2c0.1,1.2,1.3,2,2.9,2c1.7,0,3-0.9,3-2.2 c0-1.1-0.7-1.7-2.1-2l-1.1-0.3c-0.9-0.2-1.3-0.5-1.3-1c0-0.7,0.7-1.1,1.6-1.1c0.9,0,1.5,0.4,1.6,1h1.2c-0.2-1.2-1.2-2-2.8-2 C81.5,170.5,80.3,171.4,80.3,172.6z M88.1,168.7v1.9h-1.2v1h1.2v4.5c0,1.4,0.6,2,2.1,2c0.2,0,0.5,0,0.7-0.1v-1c-0.2,0-0.3,0-0.5,0 c-0.8,0-1.1-0.4-1.1-1.2v-4.2h1.6v-1h-1.6v-1.9H88.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "selectControl",
    d: "M140.7,175l3.3,5.8l3.3-5.8H140.7z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "selectControl",
    d: "M147.3,172l-3.3-5.8l-3.3,5.8H147.3z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    id: "pagination"
  }, /*#__PURE__*/_react.default.createElement("path", {
    className: "outerBox",
    d: "M420,430c-2.2,0-4,1.8-4,4v28c0,2.2,1.8,4,4,4h53v-36H420z M477,430v36h53c2.2,0,4-1.8,4-4v-28 c0-2.2-1.8-4-4-4H477z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "arrow",
    d: "M503,444.2c-0.4-0.4-0.4-1,0-1.4c0.4-0.4,1-0.4,1.4,0l4.5,4.5c0.4,0.4,0.4,1,0,1.4l-4.5,4.5 c-0.4,0.4-1,0.4-1.4,0c-0.4-0.4-0.4-1,0-1.4l3.8-3.8L503,444.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    className: "arrow",
    d: "M447,451.8c0.4,0.4,0.4,1,0,1.4c-0.4,0.4-1,0.4-1.4,0l-4.5-4.5c-0.4-0.4-0.4-1,0-1.4l4.5-4.5 c0.4-0.4,1-0.4,1.4,0c0.4,0.4,0.4,1,0,1.4l-3.8,3.8L447,451.8z"
  })));
};
exports.SearchUIGraphic = SearchUIGraphic;