"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelevanceTuningForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _relevance_tuning_logic = require("../relevance_tuning_logic");
var _relevance_tuning_item = require("./relevance_tuning_item");
var _relevance_tuning_item_content = require("./relevance_tuning_item_content");
require("./relevance_tuning_form.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RelevanceTuningForm = () => {
  const {
    filterInputValue,
    schemaFields,
    filteredSchemaFields,
    filteredSchemaFieldsWithConflicts,
    schema,
    searchSettings
  } = (0, _kea.useValues)(_relevance_tuning_logic.RelevanceTuningLogic);
  const {
    setFilterValue
  } = (0, _kea.useActions)(_relevance_tuning_logic.RelevanceTuningLogic);
  return /*#__PURE__*/_react.default.createElement("section", {
    className: "relevanceTuningForm"
  }, /*#__PURE__*/_react.default.createElement("form", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.title', {
    defaultMessage: 'Manage fields'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), schemaFields.length > _constants.FIELD_FILTER_CUTOFF && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: filterInputValue,
    onChange: e => setFilterValue(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.filterPlaceholder', {
      defaultMessage: 'Filter {schemaFieldsLength} fields...',
      values: {
        schemaFieldsLength: schemaFields.length
      }
    }),
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), filteredSchemaFields.map(fieldName => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: fieldName,
    hasBorder: true,
    className: "relevanceTuningForm__panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: fieldName,
    id: fieldName,
    buttonContentClassName: "relevanceTuningForm__item",
    buttonContent: /*#__PURE__*/_react.default.createElement(_relevance_tuning_item.RelevanceTuningItem, {
      name: fieldName,
      type: schema[fieldName].type,
      boosts: searchSettings.boosts && searchSettings.boosts[fieldName],
      field: searchSettings.search_fields[fieldName]
    }),
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_relevance_tuning_item_content.RelevanceTuningItemContent, {
    name: fieldName,
    type: schema[fieldName].type,
    boosts: searchSettings.boosts && searchSettings.boosts[fieldName],
    field: searchSettings.search_fields[fieldName]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), filteredSchemaFieldsWithConflicts.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "DisabledFieldsSection"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.disabledFields.title', {
    defaultMessage: 'Disabled fields'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), filteredSchemaFieldsWithConflicts.map(fieldName => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: fieldName,
    hasBorder: true,
    className: "relevanceTuningForm__panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "DisabledField"
  }, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.disabledFieldsExplanationMessage', {
    defaultMessage: 'Inactive due to field-type conflict'
  })))))));
};
exports.RelevanceTuningForm = RelevanceTuningForm;