"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiInputRows = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _eui = require("@elastic/eui");
var _constants = require("../../../shared/constants");
var _constants2 = require("./constants");
var _input_row = require("./input_row");
var _multi_input_rows_logic = require("./multi_input_rows_logic");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiInputRows = ({
  id,
  initialValues = [''],
  onChange,
  onSubmit,
  showSubmitButton = true,
  submitButtonText = _constants.CONTINUE_BUTTON_LABEL,
  addRowText = _constants2.ADD_VALUE_BUTTON_LABEL,
  deleteRowLabel,
  inputPlaceholder = _constants2.INPUT_ROW_PLACEHOLDER
}) => {
  const logic = (0, _multi_input_rows_logic.MultiInputRowsLogic)({
    id,
    values: initialValues
  });
  const {
    values,
    addedNewRow,
    hasEmptyValues,
    hasOnlyOneValue
  } = (0, _kea.useValues)(logic);
  const {
    addValue,
    editValue,
    deleteValue
  } = (0, _kea.useActions)(logic);
  const valuesContainerRef = (0, _react.useRef)(null);
  (0, _useUpdateEffect.default)(() => {
    if (onChange) {
      onChange((0, _utils.filterEmptyValues)(values));
    }
  }, [values]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: id,
    component: onSubmit ? 'form' : 'div',
    onSubmit: onSubmit ? e => {
      e.preventDefault();
      onSubmit((0, _utils.filterEmptyValues)(values));
    } : undefined
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: valuesContainerRef,
    role: "group",
    tabIndex: -1,
    "aria-label": _constants2.INPUT_ROW_CONTAINER_ARIA_LABEL
  }, values.map((value, index) => {
    const firstRow = index === 0;
    const lastRow = index === values.length - 1;
    return /*#__PURE__*/_react.default.createElement(_input_row.InputRow, {
      key: `inputRow-${id}-${index}`,
      value: value,
      placeholder: inputPlaceholder,
      autoFocus: addedNewRow ? lastRow : firstRow,
      onChange: newValue => editValue(index, newValue),
      onDelete: () => {
        var _valuesContainerRef$c;
        deleteValue(index);
        (_valuesContainerRef$c = valuesContainerRef.current) === null || _valuesContainerRef$c === void 0 ? void 0 : _valuesContainerRef$c.focus();
      },
      disableDelete: hasOnlyOneValue,
      deleteLabel: deleteRowLabel || (0, _constants2.DELETE_ROW_VALUE_BUTTON_LABEL)(index + 1)
    });
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "plusInCircle",
    onClick: addValue,
    isDisabled: hasEmptyValues,
    "data-test-subj": "addInputRowButton"
  }, addRowText), showSubmitButton && onSubmit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: hasOnlyOneValue && hasEmptyValues,
    "data-test-subj": "submitInputValuesButton",
    type: "submit"
  }, submitButtonText)));
};
exports.MultiInputRows = MultiInputRows;