"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConflictingEnginesSet = exports.getConflictingEnginesFromSchemaConflicts = exports.getConflictingEnginesFromConflictingField = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConflictingEnginesFromConflictingField = conflictingField => Object.values(conflictingField).flat();
exports.getConflictingEnginesFromConflictingField = getConflictingEnginesFromConflictingField;
const getConflictingEnginesFromSchemaConflicts = schemaConflicts => Object.values(schemaConflicts).flatMap(getConflictingEnginesFromConflictingField);

// Given a meta-engine (represented by IEngineDetails), generate a Set of all source engines
// who have schema conflicts in the context of that meta-engine
//
// A Set allows us to enforce uniqueness and has O(1) lookup time
exports.getConflictingEnginesFromSchemaConflicts = getConflictingEnginesFromSchemaConflicts;
const getConflictingEnginesSet = metaEngine => {
  const conflictingEngines = metaEngine.schemaConflicts ? getConflictingEnginesFromSchemaConflicts(metaEngine.schemaConflicts) : [];
  return new Set(conflictingEngines);
};
exports.getConflictingEnginesSet = getConflictingEnginesSet;