"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentApiLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _api_logs = require("../../api_logs");
var _constants = require("../../api_logs/constants");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _constants2 = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentApiLogs = () => {
  const {
    fetchApiLogs,
    pollForApiLogs
  } = (0, _kea.useActions)(_api_logs.ApiLogsLogic);
  (0, _react.useEffect)(() => {
    fetchApiLogs();
    pollForApiLogs();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.RECENT_API_EVENTS),
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_api_logs.NewApiEventsPrompt, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      iconType: "eye",
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_API_LOGS_PATH),
      size: "s"
    }, _constants2.VIEW_API_LOGS))),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_api_logs.ApiLogsTable, null), /*#__PURE__*/_react.default.createElement(_api_logs.ApiLogFlyout, null));
};
exports.RecentApiLogs = RecentApiLogs;