"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsPerPageView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapResultsPerPageOptionForEuiSelect = option => ({
  text: option,
  value: option
});
const ResultsPerPageView = ({
  onChange,
  options = [],
  value = 20
}) => {
  // If we don't have the value in options, unset it
  const selectedValue = value && !options.includes(value) ? undefined : value;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: options.map(wrapResultsPerPageOptionForEuiSelect),
    value: selectedValue,
    prepend: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.resultsPerPage.show', {
      defaultMessage: 'Show:'
    }),
    onChange: event => onChange(parseInt(event.target.value, 10)),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.resultsPerPage.ariaLabel', {
      defaultMessage: 'Number of results to show per page'
    })
  }));
};
exports.ResultsPerPageView = ResultsPerPageView;