"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _engine = require("../../engine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldNameToComboBoxOption = fieldName => ({
  label: fieldName
});
const comboBoxOptionToFieldName = ({
  label
}) => label;
const CustomizationModal = ({
  filterFields,
  onClose,
  onSave,
  sortFields
}) => {
  const {
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [selectedFilterFields, setSelectedFilterFields] = (0, _react.useState)(filterFields.map(fieldNameToComboBoxOption));
  const [selectedSortFields, setSelectedSortFields] = (0, _react.useState)(sortFields.map(fieldNameToComboBoxOption));
  const schema = engine.advancedSchema || {};
  const selectableFilterFields = (0, _react.useMemo)(() => Object.keys(schema).filter(fieldName => schema[fieldName].capabilities.filter).map(fieldNameToComboBoxOption), [schema]);
  const selectableSortFields = (0, _react.useMemo)(() => Object.keys(schema).filter(fieldName => schema[fieldName].capabilities.sort).map(fieldNameToComboBoxOption), [schema]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationModal.title', {
    defaultMessage: 'Customize document search'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationModal.filterFieldsLabel', {
      defaultMessage: 'Filter fields'
    }),
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationModal.filterFields', {
      defaultMessage: 'Faceted values rendered as filters and available as query refinement'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "filterFieldsDropdown",
    fullWidth: true,
    options: selectableFilterFields,
    selectedOptions: selectedFilterFields,
    onChange: setSelectedFilterFields
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationModal.sortFieldsLabel', {
      defaultMessage: 'Sort fields'
    }),
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.customizationModal.sortFields', {
      defaultMessage: 'Used to display result sorting options, ascending and descending'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "sortFieldsDropdown",
    fullWidth: true,
    options: selectableSortFields,
    selectedOptions: selectedSortFields,
    onChange: setSelectedSortFields
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchCustomizationModalButton",
    onClick: onClose
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchCustomizationModalButton",
    fill: true,
    onClick: () => {
      onSave({
        filterFields: selectedFilterFields.map(comboBoxOptionToFieldName),
        sortFields: selectedSortFields.map(comboBoxOptionToFieldName)
      });
    }
  }, _constants.SAVE_BUTTON_LABEL)));
};
exports.CustomizationModal = CustomizationModal;