"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationsSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _licensing = require("../../../../../shared/licensing");
var _loading = require("../../../../../shared/loading");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _data_panel = require("../../../data_panel");
var _engine = require("../../../engine");
var _automated_icon = require("../../components/automated_icon");
var _curations_settings_logic = require("./curations_settings_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationsSettings = () => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    curationsSettings: {
      enabled,
      mode
    },
    dataLoading
  } = (0, _kea.useValues)(_curations_settings_logic.CurationsSettingsLogic);
  const {
    loadCurationsSettings,
    onSkipLoadingCurationsSettings,
    toggleCurationsEnabled,
    toggleCurationsMode
  } = (0, _kea.useActions)(_curations_settings_logic.CurationsSettingsLogic);
  const {
    engine: {
      analytics_enabled: analyticsEnabled
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  (0, _react.useEffect)(() => {
    if (analyticsEnabled && dataLoading) {
      loadCurationsSettings();
    } else {
      onSkipLoadingCurationsSettings();
    }
  }, [analyticsEnabled, dataLoading]);
  if (!hasPlatinumLicense) return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.licenseUpgradeCTATitle', {
      defaultMessage: 'Introducing curations powered by adaptive relevance'
    })),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.appSearch.curations.settings.licenseUpgradeCTASubtitle",
      defaultMessage: "Upgrade to a {platinumLicenseName} subscription to harness the power of machine learning. By analyzing your engine's analytics, App Search is able to suggest new or updated curations. Effortlessly help your users find exactly what they're looking for. Start a free trial today.",
      values: {
        platinumLicenseName: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.platinum', {
          defaultMessage: 'Platinum'
        }))
      }
    }),
    action: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: "/app/management/stack/license_management",
      shouldNotCreateHref: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.curations.settings.start30DayTrialButtonLabel', {
      defaultMessage: 'Start a 30-day trial'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    target: "_blank",
    iconType: "popout",
    href: _doc_links.docLinks.licenseManagement
  }, _i18n.i18n.translate('xpack.enterpriseSearch.curations.settings.licenseUpgradeLink', {
    defaultMessage: 'Learn more about license upgrades'
  })));
  if (dataLoading) return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _automated_icon.AutomatedIcon,
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.automaticCurationsTitle', {
    defaultMessage: 'Curations powered by adaptive relevance'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !analyticsEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.analyticsDisabledCalloutTitle', {
      defaultMessage: 'Analytics are disabled'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.analyticsDisabledCalloutDescription', {
    defaultMessage: 'Adaptive relevance requires analytics to be enabled on your account.'
  })), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    fill: true,
    size: "s",
    to: _routes.SETTINGS_PATH
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.manageAnalyticsButtonLabel', {
    defaultMessage: 'Manage analytics'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.automaticCurationsDescription', {
    defaultMessage: "App Search will monitor your engine's analytics and suggest changes to your curations to help you deliver the most relevant results. Each suggestion can be accepted, rejected, or modified."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.enableautomaticCurationsSwitchLabel', {
      defaultMessage: 'Enable suggestions'
    }),
    checked: enabled,
    disabled: !analyticsEnabled,
    onChange: toggleCurationsEnabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.settings.acceptNewSuggesstionsSwitchLabel', {
      defaultMessage: 'Automatically accept new suggestions'
    }),
    checked: mode === 'automatic',
    disabled: !analyticsEnabled,
    onChange: toggleCurationsMode
  }))));
};
exports.CurationsSettings = CurationsSettings;