"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationResultPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../../../engine");
var _result = require("../../../result");
require("./curation_result_panel.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationResultPanel = ({
  variant,
  results
}) => {
  const {
    isMetaEngine,
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const count = results.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "curationResultPanel__header",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    "data-test-subj": "curationCount"
  }, count)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.resultPanelTitle', {
    defaultMessage: 'Promoted results'
  })))), variant === 'suggested' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "suggestedText"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "right",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.resultPanelDescription', {
    defaultMessage: 'This curation can be automated by App Search'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: results.length > 0 ? 'flexStart' : 'center',
    gutterSize: "s",
    direction: "column",
    className: `curationResultPanel curationResultPanel--${variant}`
  }, results.length > 0 ? results.map((result, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: result.id.raw,
    style: {
      width: '100%'
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result.Result, {
    result: result,
    isMetaEngine: isMetaEngine,
    schemaForTypeHighlights: engine.schema,
    resultPosition: index + 1,
    showClick: true
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "noResults"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.noResultsMessage', {
    defaultMessage: 'There are currently no promoted documents for this query'
  }))))));
};
exports.CurationResultPanel = CurationResultPanel;