"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationActionBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _curation_actions_popover = require("./curation_actions_popover");
var _curation_suggestion_logic = require("./curation_suggestion_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationActionBar = () => {
  const {
    acceptSuggestion,
    rejectSuggestion
  } = (0, _kea.useActions)(_curation_suggestion_logic.CurationSuggestionLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.title', {
    defaultMessage: 'Manage suggestion'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    color: "danger",
    iconType: "cross",
    "data-test-subj": "rejectButton",
    onClick: rejectSuggestion
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.rejectButtonLabel', {
    defaultMessage: 'Reject'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    color: "success",
    iconType: "checkInCircleFilled",
    "data-test-subj": "acceptButton",
    onClick: acceptSuggestion
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.acceptButtonLabel', {
    defaultMessage: 'Accept'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_curation_actions_popover.CurationActionsPopover, null))))))));
};
exports.CurationActionBar = CurationActionBar;