"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrganicDocuments = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _icons = require("../../../../../shared/icons");
var _data_panel = require("../../../data_panel");
var _constants = require("../../constants");
var _curation_logic = require("../curation_logic");
var _results = require("../results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OrganicDocuments = () => {
  const {
    addPromotedId,
    addHiddenId
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  const {
    curation,
    activeQuery,
    isAutomated,
    organicDocumentsLoading
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  const documents = curation.organic || [];
  const hasDocuments = documents.length > 0 && !organicDocumentsLoading;
  const currentQuery = activeQuery;
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    iconType: _icons.LeafIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.organicDocuments.title', {
      defaultMessage: 'Top organic documents for "{currentQuery}"',
      values: {
        currentQuery
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5,
    isLoading: organicDocumentsLoading
  }, hasDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, documents.map((document, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_results.CurationResult, {
    result: document,
    index: index,
    actions: isAutomated ? [] : [{
      ..._constants.HIDE_DOCUMENT_ACTION,
      onClick: () => addHiddenId(document.id.raw)
    }, {
      ..._constants.PROMOTE_DOCUMENT_ACTION,
      onClick: () => addPromotedId(document.id.raw)
    }]
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.appSearch.engine.curations.organicDocuments.description",
      defaultMessage: "No organic results to display.{manualDescription}",
      values: {
        manualDescription: !isAutomated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.appSearch.engine.curations.organicDocuments.manualDescription",
          defaultMessage: "Add or change the active query above."
        }))
      }
    })
  })));
};
exports.OrganicDocuments = OrganicDocuments;