"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Curation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _layout = require("../../../../shared/layout");
var _automated_curation = require("./automated_curation");
var _curation_logic = require("./curation_logic");
var _manual_curation = require("./manual_curation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Curation = () => {
  const {
    curationId
  } = (0, _reactRouterDom.useParams)();
  const {
    loadCuration
  } = (0, _kea.useActions)((0, _curation_logic.CurationLogic)({
    curationId
  }));
  const {
    dataLoading,
    isAutomated
  } = (0, _kea.useValues)((0, _curation_logic.CurationLogic)({
    curationId
  }));
  (0, _react.useEffect)(() => {
    loadCuration();
  }, [curationId]);
  if (dataLoading) {
    return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, {
      isLoading: true
    });
  }
  return isAutomated ? /*#__PURE__*/_react.default.createElement(_automated_curation.AutomatedCuration, null) : /*#__PURE__*/_react.default.createElement(_manual_curation.ManualCuration, null);
};
exports.Curation = Curation;