"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsLogic = void 0;
var _kea = require("kea");
var _constants = require("../../../../shared/constants");
var _flash_messages = require("../../../../shared/flash_messages");
var _http = require("../../../../shared/http");
var _table_pagination = require("../../../../shared/table_pagination");
var _engine = require("../../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestionsLogic = exports.SuggestionsLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'curations', 'suggestions_logic'],
  actions: () => ({
    onPaginate: newPageIndex => ({
      newPageIndex
    }),
    onSuggestionsLoaded: ({
      results,
      meta
    }) => ({
      results,
      meta
    }),
    loadSuggestions: true
  }),
  reducers: () => ({
    dataLoading: [true, {
      loadSuggestions: () => true,
      onSuggestionsLoaded: () => false
    }],
    suggestions: [[], {
      onSuggestionsLoaded: (_, {
        results
      }) => results
    }],
    meta: [{
      ..._constants.DEFAULT_META,
      page: {
        ..._constants.DEFAULT_META.page,
        size: 10
      }
    }, {
      onSuggestionsLoaded: (_, {
        meta
      }) => meta,
      onPaginate: (state, {
        newPageIndex
      }) => (0, _table_pagination.updateMetaPageIndex)(state, newPageIndex)
    }]
  }),
  listeners: ({
    actions,
    values
  }) => ({
    loadSuggestions: async () => {
      const {
        meta
      } = values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.post(`/internal/app_search/engines/${engineName}/adaptive_relevance/suggestions`, {
          body: JSON.stringify({
            page: {
              current: meta.page.current,
              size: meta.page.size
            },
            filters: {
              status: ['pending'],
              type: 'curation'
            }
          })
        });
        actions.onSuggestionsLoaded(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});