"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormKeyName = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _credentials_logic = require("../../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormKeyName = () => {
  const {
    setNameInputBlurred,
    setTokenName
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiToken: {
      name
    },
    activeApiTokenRawName: rawName,
    activeApiTokenExists
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formName.label', {
      defaultMessage: 'Key name'
    }),
    helpText: !!name && name !== rawName ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formName.helpText', {
      defaultMessage: 'Your key will be named: {name}',
      values: {
        name
      }
    }) : '',
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "raw_name",
    id: "raw_name",
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formName.placeholder', {
      defaultMessage: 'i.e., my-engine-key'
    }),
    "data-test-subj": "APIKeyField",
    value: rawName,
    onChange: e => setTokenName(e.target.value),
    onBlur: () => setNameInputBlurred(true),
    autoComplete: "off",
    maxLength: 64,
    disabled: activeApiTokenExists,
    required: true,
    fullWidth: true,
    autoFocus: true
  }));
};
exports.FormKeyName = FormKeyName;