"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormKeyEngineAccess = exports.EngineSelection = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../../../app_logic");
var _credentials_logic = require("../../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormKeyEngineAccess = () => {
  const {
    myRole
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    setAccessAllEngines
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    fullEngineAccessChecked
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.label', {
      defaultMessage: 'Engine Access Control'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: "engine_access",
    id: "all_engines",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.fullAccess.label', {
      defaultMessage: 'Full Engine Access'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.fullAccess.helpText', {
      defaultMessage: 'Access to all current and future Engines.'
    }))),
    hidden: !myRole.canAccessAllEngines,
    checked: fullEngineAccessChecked,
    value: fullEngineAccessChecked.toString(),
    onChange: () => setAccessAllEngines(true)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: "engine_access",
    id: "specific_engines",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.limitedAccess.label', {
      defaultMessage: 'Limited Engine Access'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.limitedAccess.helpText', {
      defaultMessage: 'Limit key access to specific Engines.'
    }))),
    checked: !fullEngineAccessChecked,
    value: (!fullEngineAccessChecked).toString(),
    onChange: () => setAccessAllEngines(false)
  }))), !fullEngineAccessChecked && /*#__PURE__*/_react.default.createElement(EngineSelection, null));
};
exports.FormKeyEngineAccess = FormKeyEngineAccess;
const EngineSelection = () => {
  const {
    onEngineSelect
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiToken,
    engines
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.engineAccess.label', {
    defaultMessage: 'Select Engines'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formEngineAccess.engineAccess.helpText', {
    defaultMessage: 'Engines which the key can access:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), engines.map(engine => {
    var _activeApiToken$engin;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      key: engine.name,
      name: engine.name,
      id: `engine_${engine.name}`,
      label: engine.name,
      checked: !!(activeApiToken !== null && activeApiToken !== void 0 && (_activeApiToken$engin = activeApiToken.engines) !== null && _activeApiToken$engin !== void 0 && _activeApiToken$engin.includes(engine.name)),
      onChange: () => onEngineSelect(engine.name)
    });
  })));
};
exports.EngineSelection = EngineSelection;