"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsFlyoutFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _credentials_logic = require("../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsFlyoutFooter = () => {
  const {
    hideCredentialsForm,
    onApiTokenChange
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiTokenExists
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: hideCredentialsForm
  }, _constants.CLOSE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApiTokenChange,
    fill: true,
    color: "success",
    iconType: "check",
    "data-test-subj": "APIKeyActionButton"
  }, activeApiTokenExists ? _constants.UPDATE_BUTTON_LABEL : _constants.SAVE_BUTTON_LABEL))));
};
exports.CredentialsFlyoutFooter = CredentialsFlyoutFooter;