"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewAllButton = exports.Analytics = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _icons = require("../../../icons");
var _routes = require("../../../routes");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _suggested_curations_callout = require("../../engine_overview/components/suggested_curations_callout");
var _analytics_layout = require("../analytics_layout");
var _components = require("../components");
var _constants = require("../constants");
require("./analytics.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Analytics = () => {
  const {
    totalQueries,
    totalQueriesNoResults,
    totalClicks,
    queriesPerDay,
    queriesNoResultsPerDay,
    clicksPerDay,
    startDate,
    topQueries,
    topQueriesNoResults,
    topQueriesWithClicks,
    topQueriesNoClicks,
    recentQueries
  } = (0, _kea.useValues)(_.AnalyticsLogic);
  return /*#__PURE__*/_react.default.createElement(_analytics_layout.AnalyticsLayout, {
    isAnalyticsView: true,
    title: _constants.ANALYTICS_TITLE
  }, /*#__PURE__*/_react.default.createElement(_suggested_curations_callout.SuggestedCurationsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_.AnalyticsCards, {
    stats: [{
      stat: totalQueries,
      text: _constants.TOTAL_QUERIES,
      dataTestSubj: 'TotalQueriesCard'
    }, {
      stat: totalQueriesNoResults,
      text: _constants.TOTAL_QUERIES_NO_RESULTS,
      dataTestSubj: 'TotalQueriesNoResultsCard'
    }, {
      stat: totalClicks,
      text: _constants.TOTAL_CLICKS,
      dataTestSubj: 'TotalClicksCard'
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_.AnalyticsChart, {
    lines: [{
      id: _constants.TOTAL_QUERIES,
      data: (0, _.convertToChartData)({
        startDate,
        data: queriesPerDay
      })
    }, {
      id: _constants.TOTAL_QUERIES_NO_RESULTS,
      data: (0, _.convertToChartData)({
        startDate,
        data: queriesNoResultsPerDay
      }),
      isDashed: true
    }, {
      id: _constants.TOTAL_CLICKS,
      data: (0, _.convertToChartData)({
        startDate,
        data: clicksPerDay
      }),
      isDashed: true
    }]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.AnalyticsSection, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryTablesTitle', {
      defaultMessage: 'Query analytics'
    }),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryTablesDescription', {
      defaultMessage: 'Gain insight into the most frequent queries, and which queries returned no results.'
    }),
    iconType: "search"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "analyticsOverviewTables"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _constants.TOP_QUERIES),
    filled: true,
    action: /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_TOP_QUERIES_PATH)
    })
  }, /*#__PURE__*/_react.default.createElement(_components.AnalyticsTable, {
    items: topQueries.slice(0, 10),
    hasClicks: true,
    isSmall: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _constants.TOP_QUERIES_NO_RESULTS),
    filled: true,
    action: /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_TOP_QUERIES_NO_RESULTS_PATH)
    })
  }, /*#__PURE__*/_react.default.createElement(_components.AnalyticsTable, {
    items: topQueriesNoResults.slice(0, 10),
    isSmall: true
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_components.AnalyticsSection, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.clickTablesTitle', {
      defaultMessage: 'Click analytics'
    }),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.clickTablesDescription', {
      defaultMessage: 'Discover which queries generated the most and least amount of clicks.'
    }),
    iconType: _icons.CursorIcon
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "analyticsOverviewTables"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _constants.TOP_QUERIES_WITH_CLICKS),
    filled: true,
    action: /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_TOP_QUERIES_WITH_CLICKS_PATH)
    })
  }, /*#__PURE__*/_react.default.createElement(_components.AnalyticsTable, {
    items: topQueriesWithClicks.slice(0, 10),
    hasClicks: true,
    isSmall: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _constants.TOP_QUERIES_NO_CLICKS),
    filled: true,
    action: /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_TOP_QUERIES_NO_CLICKS_PATH)
    })
  }, /*#__PURE__*/_react.default.createElement(_components.AnalyticsTable, {
    items: topQueriesNoClicks.slice(0, 10),
    isSmall: true
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.RECENT_QUERIES),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.recentQueriesDescription', {
      defaultMessage: 'A view into queries happening right now.'
    }),
    action: /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_RECENT_QUERIES_PATH)
    })
  }, /*#__PURE__*/_react.default.createElement(_components.RecentQueriesTable, {
    items: recentQueries.slice(0, 10)
  })));
};
exports.Analytics = Analytics;
const ViewAllButton = ({
  to
}) => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
  to: to,
  size: "s",
  iconType: "eye"
}, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.viewAllButtonLabel', {
  defaultMessage: 'View all'
}));
exports.ViewAllButton = ViewAllButton;