"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToChartData = exports.convertTagsToSelectOptions = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToChartData = ({
  data,
  startDate
}) => {
  const date = (0, _moment.default)(startDate, _constants.SERVER_DATE_FORMAT);
  return data.map((y, index) => ({
    x: (0, _moment.default)(date).add(index, 'days').format(_constants.SERVER_DATE_FORMAT),
    y
  }));
};
exports.convertToChartData = convertToChartData;
const convertTagsToSelectOptions = tags => {
  // Our server API returns an initial default tag for us, but we don't want to use it because
  // it's not i18n'ed, and also setting the value to '' is nicer for select/param UX
  tags = tags.slice(1);
  const DEFAULT_OPTION = {
    value: '',
    text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.allTagsDropDownOptionLabel', {
      defaultMessage: 'All analytics tags'
    })
  };
  return [DEFAULT_OPTION, ...tags.map(tag => ({
    value: tag,
    text: tag
  }))];
};
exports.convertTagsToSelectOptions = convertTagsToSelectOptions;