"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionToolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _delete_analytics_collection_logic = require("../delete_analytics_collection_logic");
var _fetch_analytics_collection_logic = require("../fetch_analytics_collection_logic");
var _use_discover_link = require("../use_discover_link");
var _analytics_collection_toolbar_logic = require("./analytics_collection_toolbar_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuickRanges = [{
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last7Days', {
    defaultMessage: 'Last 7 days'
  }),
  start: 'now-7d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last2Weeks', {
    defaultMessage: 'Last 2 weeks'
  }),
  start: 'now-14d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last30Days', {
    defaultMessage: 'Last 30 days'
  }),
  start: 'now-30d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last90Days', {
    defaultMessage: 'Last 90 days'
  }),
  start: 'now-90d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last1Year', {
    defaultMessage: 'Last 1 year'
  }),
  start: 'now-1y'
}];
const AnalyticsCollectionToolbar = () => {
  const discoverLink = (0, _use_discover_link.useDiscoverLink)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    application,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    analyticsCollection
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    setTimeRange,
    setRefreshInterval,
    onTimeRefresh
  } = (0, _kea.useActions)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const {
    refreshInterval,
    timeRange
  } = (0, _kea.useValues)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const {
    deleteAnalyticsCollection
  } = (0, _kea.useActions)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  const {
    isLoading
  } = (0, _kea.useValues)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  const manageDatastreamUrl = application.getUrlForApp('management', {
    path: '/data/index_management/data_streams/' + analyticsCollection.events_datastream
  });
  const handleTimeChange = ({
    start: from,
    end: to
  }) => {
    setTimeRange({
      from,
      to
    });
  };
  const closePopover = () => {
    setPopover(false);
  };
  const togglePopover = () => {
    setPopover(!isPopoverOpen);
  };
  const onRefreshChange = ({
    isPaused: pause,
    refreshInterval: value
  }) => {
    setRefreshInterval({
      pause,
      value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    refreshInterval: refreshInterval.value,
    isPaused: refreshInterval.pause,
    onTimeChange: handleTimeChange,
    onRefresh: onTimeRefresh,
    onRefreshChange: onRefreshChange,
    showUpdateButton: "iconOnly",
    updateButtonProps: {
      fill: false
    },
    width: "full",
    commonlyUsedRanges: defaultQuickRanges
  })), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.analytics.collectionsView.manageButton",
      defaultMessage: "Manage"
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downRight",
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "link",
    size: "s",
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-integrate-tracker-link',
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_INTEGRATE_PATH, {
      name: analyticsCollection.name
    }))
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.integrateTracker",
    defaultMessage: "Integrate JS tracker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "database",
    size: "s",
    href: manageDatastreamUrl,
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-manage-datastream-link'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.manageEventsDatastream",
    defaultMessage: "Manage events datastream"
  })), discoverLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "visArea",
    href: discoverLink,
    size: "s",
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-manage-discover-link'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.openInDiscover",
    defaultMessage: "Create dashboards in Discover"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    color: "danger",
    fullWidth: true,
    isLoading: !isLoading,
    disabled: !isLoading,
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-delete-collection-button',
    size: "s",
    onClick: () => {
      deleteAnalyticsCollection(analyticsCollection.name);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.delete.buttonTitle",
    defaultMessage: "Delete collection"
  }))))))));
};
exports.AnalyticsCollectionToolbar = AnalyticsCollectionToolbar;