"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAnalyticsCollections = exports.FetchAnalyticsCollectionsAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAnalyticsCollections = async ({
  query = ''
}) => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = '/internal/elasticsearch/analytics/collections';
  const response = await http.get(route, {
    query: {
      query
    }
  });
  return response;
};
exports.fetchAnalyticsCollections = fetchAnalyticsCollections;
const FetchAnalyticsCollectionsAPILogic = exports.FetchAnalyticsCollectionsAPILogic = (0, _create_api_logic.createApiLogic)(['analytics', 'analytics_collections_api_logic'], fetchAnalyticsCollections);