"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStateAnnotation = ({
  getFormattedTime
}) => {
  const graphAnnotation = _langgraph.Annotation.Root({
    input: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => ''
    }),
    lastNode: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => 'start'
    }),
    steps: (0, _langgraph.Annotation)({
      reducer: (x, y) => x.concat(y),
      default: () => []
    }),
    hasRespondStep: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => false
    }),
    agentOutcome: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => undefined
    }),
    messages: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => []
    }),
    chatTitle: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => ''
    }),
    llmType: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => 'unknown'
    }),
    isStream: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => false
    }),
    isOssModel: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => false
    }),
    connectorId: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => ''
    }),
    conversation: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => undefined
    }),
    conversationId: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => ''
    }),
    responseLanguage: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => 'English'
    }),
    provider: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: () => ''
    }),
    formattedTime: (0, _langgraph.Annotation)({
      reducer: (x, y) => y !== null && y !== void 0 ? y : x,
      default: getFormattedTime !== null && getFormattedTime !== void 0 ? getFormattedTime : () => ''
    })
  });
  return graphAnnotation;
};
exports.getStateAnnotation = getStateAnnotation;