"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerationStatusOrThrow = void 0;
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerationStatusOrThrow = ({
  executionUuid,
  eventActions
}) => {
  if (!eventActions.includes(_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED)) {
    throw new Error(`Generation ${executionUuid} is missing ${_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED} event.action`);
  }
  if (eventActions.includes(_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_DISMISSED)) {
    return 'dismissed';
  }
  if (eventActions.includes(_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_FAILED)) {
    return 'failed';
  }
  if (eventActions.includes(_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_SUCCEEDED)) {
    return 'succeeded';
  }
  if (eventActions.includes(_constants.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_CANCELED)) {
    return 'canceled';
  }
  return 'started';
};
exports.getGenerationStatusOrThrow = getGenerationStatusOrThrow;