"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openKnowledgeBasePageByEntryId = exports.openAlertsPageByOpenAndAck = exports.openAlertsPageByAlertId = void 0;
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _rison = require("@kbn/rison");
var _const = require("@kbn/elastic-assistant/impl/assistant/settings/const");
var _constants = require("../../../../hooks/navigate_to_alerts_page_with_filters/constants");
var _redirect_to_detection_engine = require("./link_to/redirect_to_detection_engine");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Opens the AI4DSOC alert summary page, filtered by alertId
 */
const openAlertSummaryPageByAlertId = (navigateToApp, alertId) => {
  const kqlAppQuery = (0, _rison.encode)({
    language: 'kuery',
    query: `_id: ${alertId}`
  });
  const urlParams = new URLSearchParams({
    [_constants.URL_PARAM_KEY.appQuery]: kqlAppQuery
  });
  return navigateToApp('securitySolutionUI', {
    deepLinkId: _deeplinksSecurity.SecurityPageName.alertSummary,
    path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)(urlParams.toString()),
    openInNewTab: true
  });
};

/**
 * Opens the Security Alerts page, triggering the flyout for an alertId.
 */
const openAlertPageByAlertId = (navigateToApp, alertId) => navigateToApp('security', {
  path: `alerts/redirect/${alertId}`,
  openInNewTab: true
});
const openAlertsPageByAlertId = (navigateToApp, alertId, hasSearchAILakeConfigurations) => {
  if (hasSearchAILakeConfigurations) {
    return openAlertSummaryPageByAlertId(navigateToApp, alertId);
  }
  return openAlertPageByAlertId(navigateToApp, alertId);
};

/**
 * Opens the AI4DSOC alert summary page with filters for open and acknowledged alerts
 */
exports.openAlertsPageByAlertId = openAlertsPageByAlertId;
const openAlertSummaryPage = navigateToApp => {
  const kqlAppQuery = (0, _rison.encode)({
    language: 'kuery',
    query: `kibana.alert.workflow_status: ${_constants2.ALERTS_PAGE_FILTER_OPEN} OR kibana.alert.workflow_status: ${_constants2.ALERTS_PAGE_FILTER_ACKNOWLEDGED}`
  });
  const urlParams = new URLSearchParams({
    [_constants.URL_PARAM_KEY.appQuery]: kqlAppQuery
  });
  return navigateToApp('securitySolutionUI', {
    deepLinkId: _deeplinksSecurity.SecurityPageName.alertSummary,
    path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)(urlParams.toString()),
    openInNewTab: true
  });
};

/**
 * Opens the Security Alerts page with filters for open and acknowledged alerts.
 */
const openAlertsPage = openAlertsPageWithFilters => openAlertsPageWithFilters({
  selectedOptions: [_constants2.ALERTS_PAGE_FILTER_OPEN, _constants2.ALERTS_PAGE_FILTER_ACKNOWLEDGED],
  fieldName: 'kibana.alert.workflow_status',
  persist: false
}, true, '(global:(timerange:(fromStr:now-24h,kind:relative,toStr:now)))');
const openAlertsPageByOpenAndAck = (navigateToApp, openAlertsPageWithFilters, hasSearchAILakeConfigurations) => {
  if (hasSearchAILakeConfigurations) {
    return openAlertSummaryPage(navigateToApp);
  }
  openAlertsPage(openAlertsPageWithFilters);
};

/**
 * Opens the AI4DSOC knowledge base management page, filtered by knowledgeBaseEntryId.
 */
exports.openAlertsPageByOpenAndAck = openAlertsPageByOpenAndAck;
const openAI4DSOCKnowledgeBasePage = (navigateToApp, knowledgeBaseEntryId) => {
  return navigateToApp('securitySolutionUI', {
    deepLinkId: _deeplinksSecurity.SecurityPageName.configurationsAiSettings,
    path: `?tab=${_const.KNOWLEDGE_BASE_TAB}&entry_search_term=${knowledgeBaseEntryId}`,
    openInNewTab: true
  });
};

/**
 * Opens the Stack management knowledge base management page
 */
const openKnowledgeBasePage = (navigateToApp, knowledgeBaseEntryId) => navigateToApp('management', {
  path: `kibana/securityAiAssistantManagement?tab=${_const.KNOWLEDGE_BASE_TAB}&entry_search_term=${knowledgeBaseEntryId}`,
  openInNewTab: true
});
const openKnowledgeBasePageByEntryId = (navigateToApp, knowledgeBaseEntryId, hasSearchAILakeConfigurations) => {
  if (hasSearchAILakeConfigurations) {
    return openAI4DSOCKnowledgeBasePage(navigateToApp, knowledgeBaseEntryId);
  }
  return openKnowledgeBasePage(navigateToApp, knowledgeBaseEntryId);
};
exports.openKnowledgeBasePageByEntryId = openKnowledgeBasePageByEntryId;