"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindKnowledgeBaseEntriesSortFieldEnum = exports.FindKnowledgeBaseEntriesSortField = exports.FindKnowledgeBaseEntriesResponse = exports.FindKnowledgeBaseEntriesRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../../common_attributes.gen");
var _common_attributes2 = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Knowledge Base Entries API endpoint
 *   version: 2023-10-31
 */

/**
 * Fields available for sorting Knowledge Base Entries.
 */

const FindKnowledgeBaseEntriesSortField = exports.FindKnowledgeBaseEntriesSortField = _zod.z.enum(['created_at', 'is_default', 'title', 'updated_at']);
const FindKnowledgeBaseEntriesSortFieldEnum = exports.FindKnowledgeBaseEntriesSortFieldEnum = FindKnowledgeBaseEntriesSortField.enum;
const FindKnowledgeBaseEntriesRequestQuery = exports.FindKnowledgeBaseEntriesRequestQuery = _zod.z.object({
  /**
   * A list of fields to include in the response. If not provided, all fields will be included.
   */
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Search query to filter Knowledge Base Entries by specific criteria.
   */
  filter: _zod.z.string().optional(),
  /**
   * Field to sort the Knowledge Base Entries by.
   */
  sort_field: FindKnowledgeBaseEntriesSortField.optional(),
  /**
   * Sort order for the results, either asc or desc.
   */
  sort_order: _common_attributes.SortOrder.optional(),
  /**
   * Page number for paginated results. Defaults to 1.
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Number of Knowledge Base Entries to return per page. Defaults to 20.
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindKnowledgeBaseEntriesResponse = exports.FindKnowledgeBaseEntriesResponse = _zod.z.object({
  /**
   * The current page number.
   */
  page: _zod.z.number().int(),
  /**
   * The number of Knowledge Base Entries returned per page.
   */
  perPage: _zod.z.number().int(),
  /**
   * The total number of Knowledge Base Entries available.
   */
  total: _zod.z.number().int(),
  /**
   * The list of Knowledge Base Entries for the current page.
   */
  data: _zod.z.array(_common_attributes2.KnowledgeBaseEntryResponse)
});