"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostAttackDiscoveryGenerationsDismissResponse = exports.PostAttackDiscoveryGenerationsDismissRequestParams = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Dismiss attack discovery generations API endpoint
 *   version: 1
 */

const PostAttackDiscoveryGenerationsDismissRequestParams = exports.PostAttackDiscoveryGenerationsDismissRequestParams = _zod.z.object({
  /**
   * The Attack discovery generations execution_uuid
   */
  execution_uuid: _common_attributes.NonEmptyString
});
const PostAttackDiscoveryGenerationsDismissResponse = exports.PostAttackDiscoveryGenerationsDismissResponse = _zod.z.object({
  /**
   * The number of alerts sent as context (max kibana.alert.rule.execution.metrics.alert_counts.active) to the LLM for the generation
   */
  alerts_context_count: _zod.z.number().optional(),
  /**
   * The connector id (event.dataset) for this generation
   */
  connector_id: _zod.z.string(),
  /**
   * Stats applicable to the connector for this generation
   */
  connector_stats: _zod.z.object({
    /**
     * The average duration (avg event.duration) in nanoseconds of successful generations for the same connector id, for the current user
     */
    average_successful_duration_nanoseconds: _zod.z.number().optional(),
    /**
     * The number of successful generations for the same connector id, for the current user
     */
    successful_generations: _zod.z.number().optional()
  }).optional(),
  /**
   * The number of new Attack discovery alerts (max kibana.alert.rule.execution.metrics.alert_counts.new) for this generation
   */
  discoveries: _zod.z.number(),
  /**
   * When generation ended (max event.end)
   */
  end: _zod.z.string().optional(),
  /**
   * The unique identifier (kibana.alert.rule.execution.uuid) for the generation
   */
  execution_uuid: _zod.z.string(),
  /**
   * Generation loading message (kibana.alert.rule.execution.status)
   */
  loading_message: _zod.z.string(),
  /**
   * Reason for failed generations (event.reason)
   */
  reason: _zod.z.string().optional(),
  /**
   * When generation started (min event.start)
   */
  start: _zod.z.string(),
  /**
   * The status of the attack discovery generation
   */
  status: _zod.z.enum(['canceled', 'dismissed', 'failed', 'started', 'succeeded'])
});