"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryFindSortField = exports.AttackDiscoveryFindResponse = exports.AttackDiscoveryFindRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../common_attributes.gen");
var _attack_discovery_alert = require("./attack_discovery_alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Attack discoveries API endpoint
 *   version: 1
 */

const AttackDiscoveryFindSortField = exports.AttackDiscoveryFindSortField = _zod.z.literal('@timestamp');
const AttackDiscoveryFindRequestQuery = exports.AttackDiscoveryFindRequestQuery = _zod.z.object({
  /**
   * filter by alert ids within attack discovery
   */
  alert_ids: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * filter by connector names
   */
  connector_names: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * filter by end date (relative or absolute)
   */
  end: _zod.z.string().optional(),
  /**
   * filter by Attack discovery IDs
   */
  ids: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Page number
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Attack discoveries per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(10),
  /**
   * filter by search query
   */
  search: _zod.z.string().optional(),
  /**
   * `undefined`: show both shared, and only visible to me Attack discoveries. `true`: show only shared Attack discoveries. `false`: show only visible to me Attack discoveries.
   */
  shared: _zodHelpers.BooleanFromString.optional(),
  /**
   * Field to sort by
   */
  sort_field: AttackDiscoveryFindSortField.optional().default('@timestamp'),
  /**
   * Sort order
   */
  sort_order: _common_attributes.SortOrder.optional().default('desc'),
  /**
   * filter by start date (relative or absolute)
   */
  start: _zod.z.string().optional(),
  /**
   * filter by kibana.alert.workflow.status
   */
  status: (0, _zodHelpers.ArrayFromString)(_zod.z.enum(['acknowledged', 'closed', 'open'])).optional()
});
const AttackDiscoveryFindResponse = exports.AttackDiscoveryFindResponse = _zod.z.object({
  connector_names: _zod.z.array(_zod.z.string()),
  data: _zod.z.array(_attack_discovery_alert.AttackDiscoveryAlert),
  page: _zod.z.number().int(),
  per_page: _zod.z.number().int().optional(),
  total: _zod.z.number().int(),
  unique_alert_ids_count: _zod.z.number().int()
});