"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  LOGS_EXPLORER_PROFILE_ID: true,
  CONTENT_FIELD: true,
  RESOURCE_FIELD: true,
  DATA_GRID_COLUMN_WIDTH_SMALL: true,
  DATA_GRID_COLUMN_WIDTH_MEDIUM: true,
  ACTIONS_COLUMN_WIDTH: true,
  RESOURCE_FIELD_CONFIGURATION: true,
  CONTENT_FIELD_CONFIGURATION: true,
  SMART_FALLBACK_FIELDS: true,
  DEFAULT_COLUMNS: true,
  DEFAULT_ROWS_PER_PAGE: true,
  FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT: true,
  FILTER_OUT_EXACT_FIELDS_FOR_CONTENT: true,
  DEFAULT_ALLOWED_DATA_VIEWS: true,
  DEFAULT_ALLOWED_LOGS_DATA_VIEWS: true,
  LOG_LEVEL_FIELDS: true,
  SERVICE_NAME_FIELDS: true,
  AGENT_NAME_FIELD: true,
  RESOURCE_FIELDS: true,
  TRACE_FIELDS: true,
  DURATION_FIELDS: true
};
exports.TRACE_FIELDS = exports.SMART_FALLBACK_FIELDS = exports.SERVICE_NAME_FIELDS = exports.RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELDS = exports.RESOURCE_FIELD = exports.LOG_LEVEL_FIELDS = exports.LOGS_EXPLORER_PROFILE_ID = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.FILTER_OUT_EXACT_FIELDS_FOR_CONTENT = exports.DURATION_FIELDS = exports.DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_COLUMNS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = exports.DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD = exports.AGENT_NAME_FIELD = exports.ACTIONS_COLUMN_WIDTH = void 0;
var _ = require("../..");
var _field_constants = require("../../field_constants");
Object.keys(_field_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _field_constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _field_constants[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LOGS_EXPLORER_PROFILE_ID = exports.LOGS_EXPLORER_PROFILE_ID = 'logs-explorer';

// Virtual column fields
const CONTENT_FIELD = exports.CONTENT_FIELD = 'content';
const RESOURCE_FIELD = exports.RESOURCE_FIELD = 'resource';

// Sizing
const DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_SMALL = 240;
const DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = 320;
const ACTIONS_COLUMN_WIDTH = exports.ACTIONS_COLUMN_WIDTH = 80;
const RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: RESOURCE_FIELD,
  fallbackFields: [_.fieldConstants.HOST_NAME_FIELD, _.fieldConstants.SERVICE_NAME_FIELD],
  width: DATA_GRID_COLUMN_WIDTH_MEDIUM
};
const CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: CONTENT_FIELD,
  fallbackFields: [_.fieldConstants.MESSAGE_FIELD]
};
const SMART_FALLBACK_FIELDS = exports.SMART_FALLBACK_FIELDS = {
  [CONTENT_FIELD]: CONTENT_FIELD_CONFIGURATION,
  [RESOURCE_FIELD]: RESOURCE_FIELD_CONFIGURATION
};

// UI preferences
const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = [RESOURCE_FIELD_CONFIGURATION, CONTENT_FIELD_CONFIGURATION];
const DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_ROWS_PER_PAGE = 100;

// List of prefixes which needs to be filtered out for Display in Content Column
const FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = ['@timestamp', 'agent.', 'elastic_agent.', 'data_stream.', 'ecs.', 'host.', 'container.', 'cloud.', 'kubernetes.', 'orchestrator.', 'log.', 'service.'];
const FILTER_OUT_EXACT_FIELDS_FOR_CONTENT = exports.FILTER_OUT_EXACT_FIELDS_FOR_CONTENT = ['_id', '_index', '_source', '_size', '_doc_count', '_field_names', '_ignored', '_routing', '_meta', '_tier'];
const DEFAULT_ALLOWED_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];
const DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];
const LOG_LEVEL_FIELDS = exports.LOG_LEVEL_FIELDS = ['log.level', 'log_level'];
const SERVICE_NAME_FIELDS = exports.SERVICE_NAME_FIELDS = ['service.name', 'service_name'];
const AGENT_NAME_FIELD = exports.AGENT_NAME_FIELD = 'agent.name';
const RESOURCE_FIELDS = exports.RESOURCE_FIELDS = [_.fieldConstants.SERVICE_NAME_FIELD, _.fieldConstants.CONTAINER_NAME_FIELD, _.fieldConstants.HOST_NAME_FIELD, _.fieldConstants.ORCHESTRATOR_NAMESPACE_FIELD, _.fieldConstants.CLOUD_INSTANCE_ID_FIELD, _.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD, _.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD, _.fieldConstants.ORCHESTRATOR_CLUSTER_ID_FIELD, _.fieldConstants.CONTAINER_ID_FIELD, _.fieldConstants.AGENT_NAME_FIELD];
const TRACE_FIELDS = exports.TRACE_FIELDS = [_.fieldConstants.SERVICE_NAME_FIELD, _.fieldConstants.EVENT_OUTCOME_FIELD, _.fieldConstants.TRANSACTION_NAME_FIELD, _.fieldConstants.TRANSACTION_DURATION_FIELD, _.fieldConstants.SPAN_NAME_FIELD, _.fieldConstants.SPAN_DURATION_FIELD, _.fieldConstants.AGENT_NAME_FIELD];
const DURATION_FIELDS = exports.DURATION_FIELDS = [_.fieldConstants.SPAN_DURATION_FIELD, _.fieldConstants.TRANSACTION_DURATION_FIELD];