"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileService = exports.BaseProfileService = exports.AsyncProfileService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable max-classes-per-file */

/**
 * The profile provider resolution result
 */

/**
 * The base profile provider interface
 */

/**
 * A synchronous profile provider interface
 */

/**
 * An asynchronous profile provider interface
 */

/**
 * Context object with an injected profile ID
 */

/**
 * Used to extract the profile type from a profile provider
 */

/**
 * Used to extract the context type from a profile provider
 */

const EMPTY_PROFILE = {};

/**
 * The base profile service implementation
 */
class BaseProfileService {
  /**
   * @param defaultContext The default context object to use when no profile provider matches
   */
  constructor(defaultContext) {
    (0, _defineProperty2.default)(this, "providers", []);
    this.defaultContext = defaultContext;
  }

  /**
   * Registers a profile provider
   * @param provider The profile provider to register
   */
  registerProvider(provider) {
    this.providers.push(provider);
  }

  /**
   * Returns the profile associated with the provided context object
   * @param context A context object returned by a provider's `resolve` method
   * @returns The profile associated with the context
   */
  getProfile(params) {
    const provider = this.providers.find(current => current.profileId === params.context.profileId);
    if (!(provider !== null && provider !== void 0 && provider.profile)) {
      return EMPTY_PROFILE;
    }
    return new Proxy(provider.profile, {
      get: (target, prop, receiver) => {
        const accessor = Reflect.get(target, prop, receiver);
        if (!(0, _lodash.isFunction)(accessor)) {
          return accessor;
        }
        return prev => accessor(prev, params);
      }
    });
  }
}

/**
 * Used to extract the parameters type from a profile provider
 */
exports.BaseProfileService = BaseProfileService;
/**
 * A synchronous profile service implementation
 */
class ProfileService extends BaseProfileService {
  /**
   * Performs context resolution based on the provided context level parameters,
   * returning the resolved context from the first matching profile provider
   * @param params Parameters specific to the service context level
   * @returns The resolved context object with an injected profile ID
   */
  resolve(params) {
    for (const provider of this.providers) {
      const result = provider.resolve(params);
      if (result.isMatch) {
        return {
          ...result.context,
          profileId: provider.profileId
        };
      }
    }
    return this.defaultContext;
  }
}

/**
 * An asynchronous profile service implementation
 */
exports.ProfileService = ProfileService;
class AsyncProfileService extends BaseProfileService {
  /**
   * Performs context resolution based on the provided context level parameters,
   * returning the resolved context from the first matching profile provider
   * @param params Parameters specific to the service context level
   * @returns The resolved context object with an injected profile ID
   */
  async resolve(params) {
    for (const provider of this.providers) {
      const result = await provider.resolve(params);
      if (result.isMatch) {
        return {
          ...result.context,
          profileId: provider.profileId
        };
      }
    }
    return this.defaultContext;
  }
}
exports.AsyncProfileService = AsyncProfileService;