"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityDocumentProfileProviders = void 0;
var _log_document_profile = require("./log_document_profile");
var _span_document_profile = require("./traces_document_profile/span_document_profile");
var _transaction_document_profile = require("./traces_document_profile/transaction_document_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createObservabilityDocumentProfileProviders = providerServices => {
  return [(0, _log_document_profile.createObservabilityLogDocumentProfileProvider)(providerServices), (0, _span_document_profile.createObservabilityTracesSpanDocumentProfileProvider)(providerServices), (0, _transaction_document_profile.createObservabilityTracesTransactionDocumentProfileProvider)(providerServices)];
};
exports.createObservabilityDocumentProfileProviders = createObservabilityDocumentProfileProviders;