"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowIndicatorProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../../../../common/data_types/logs/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getRowIndicatorProvider = () => ({
  dataView
}) => {
  // Check if the data view has any of the log level fields.
  if (!_constants.LOG_LEVEL_FIELDS.some(field => dataView.getFieldByName(field))) {
    // Otherwise, don't set the row indicator color so the color indicator control column is not added to the grid at all.
    return undefined;
  }
  return getRowIndicator;
};
exports.getRowIndicatorProvider = getRowIndicatorProvider;
const getRowIndicator = (row, euiTheme) => {
  const logLevel = _constants.LOG_LEVEL_FIELDS.reduce((acc, field) => {
    return acc || row.flattened[field];
  }, undefined);
  const logLevelCoalescedValue = (0, _discoverUtils.getLogLevelCoalescedValue)(logLevel);
  if (logLevelCoalescedValue) {
    const color = (0, _discoverUtils.getLogLevelColor)(logLevelCoalescedValue, euiTheme);
    if (!color) {
      return undefined;
    }
    return {
      color,
      label: (0, _discoverUtils.getLogLevelCoalescedValueLabel)(logLevelCoalescedValue)
    };
  }
  return undefined;
};